/*
 * Decompiled with CFR 0.152.
 */
package com.devart.dbforge.core;

import com.devart.dbforge.core.BaseLogger;
import com.devart.dbforge.core.ConnectionInfo;
import com.devart.dbforge.core.IStep;
import com.devart.dbforge.core.Parameters;
import com.devart.dbforge.core.PowerShellCommand;
import com.devart.dbforge.core.PowerShellExecutor;
import com.devart.dbforge.core.StepIds;
import com.devart.dbforge.core.Utils;
import com.devart.dbforge.core.ValidationError;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

abstract class BaseStep
implements IStep {
    private final BaseLogger logger;
    private final String serverType;
    private final String authenticationType;
    private final String server;
    private final String database;
    private final String userName;
    private final String password;
    final String packageId;
    StepIds stepId;
    String compareOptions;
    String sqlCompareFilter;
    ConnectionInfo connection;
    Path workspace;

    BaseStep(Parameters parameters, BaseLogger logger) {
        this.packageId = parameters.packageId;
        this.serverType = parameters.serverType;
        this.server = parameters.server;
        this.database = parameters.database;
        this.authenticationType = parameters.authenticationType;
        this.userName = parameters.userName;
        this.password = parameters.password;
        this.compareOptions = parameters.compareOptions;
        this.sqlCompareFilter = parameters.sqlCompareFilter;
        this.workspace = parameters.workspace;
        this.logger = logger;
    }

    @Override
    public abstract boolean run();

    boolean perform() {
        boolean result;
        this.logger.message(String.format("Started '%s'", this.getDisplayName()));
        this.logger.message(String.format("Package ID: '%s'", this.packageId));
        boolean databaseIsOk = this.createDatabase(this.workspace);
        if (databaseIsOk) {
            this.logger.debug("Database created successfully");
            this.logger.debug("getting command for execution");
            PowerShellCommand command = this.getPowerShellCommand(this.workspace);
            this.logger.debug("received command: \n" + command + "\n");
            this.logger.debug("run the command in workspace = " + this.workspace);
            result = PowerShellExecutor.getExecutor().execute(this.workspace, command, this.logger);
            this.logger.message(String.format("Finished '%s'", this.getDisplayName()));
            this.logger.message("\n");
            this.logger.debug("start removal of an instance and a database\n");
            this.dropDbAndDeleteDbInstance(this.workspace, result);
        } else {
            result = false;
        }
        return result;
    }

    protected boolean createDatabase(Path workspace) {
        this.connection = new ConnectionInfo(this.serverType.equals("localDb"), this.server, this.database, this.authenticationType.equals("windowsAuthentication"), this.userName, this.password);
        if (this.connection.isLocalDb()) {
            this.logger.debug("connection.getIsLocalDb() == true");
            this.logger.debug("get the location of the script folder");
            Path scriptLocation = workspace.resolve("PowerShell/DbForgeScripts.ps1");
            this.logger.debug("The script folder is located in " + scriptLocation);
            this.logger.debug("create LocalDb instance");
            boolean createLocalDbInstanceSuccess = PowerShellExecutor.getExecutor().execute(workspace, scriptLocation, "CreateLocalDbInstance", new String[]{"DbForgeDevopsLocalDb"}, this.logger);
            this.logger.debug("creation status localDbInstance = " + createLocalDbInstanceSuccess);
            if (createLocalDbInstanceSuccess) {
                this.logger.debug("create database instance = " + this.connection.getDatabase());
                boolean createDatabaseSuccess = this.executeScript(workspace, String.format("CREATE DATABASE \"%s\";", this.connection.getDatabase()));
                this.logger.debug("Execution status of an attempt to create a database = " + createDatabaseSuccess);
                return createDatabaseSuccess;
            }
            this.logger.debug("LocalDb Instance failed to create");
            return false;
        }
        return true;
    }

    protected void dropDbAndDeleteDbInstance(Path workspace, boolean buildSuccessful) {
        if (this.connection.isLocalDb()) {
            this.logger.debug("connection.getIsLocalDb() = " + this.connection.isLocalDb());
            this.executeScript(workspace, String.format("DROP DATABASE \"%s\";", this.connection.getDatabase()));
            Path scriptLocation = workspace.resolve("PowerShell/DbForgeScripts.ps1");
            this.logger.debug("scriptLocation = " + scriptLocation);
            this.logger.debug("execute DeleteLocalDbInstance");
            boolean success = PowerShellExecutor.getExecutor().execute(workspace, scriptLocation, "DeleteLocalDbInstance", new String[]{"DbForgeDevopsLocalDb"}, this.logger);
            this.logger.debug("Execution Status DeleteLocalDbInstance = " + success);
        }
    }

    protected abstract PowerShellCommand getPowerShellCommand(Path var1);

    protected abstract String getDisplayName();

    protected abstract List<ValidationError> validate(Parameters var1);

    private boolean executeScript(Path workspace, String script) {
        boolean result;
        Optional<Path> scriptPathOptional = Utils.generateScriptFile(workspace, script, ".sql", this.logger);
        if (scriptPathOptional.isPresent()) {
            Path scriptPath = scriptPathOptional.get();
            PowerShellCommand command = new PowerShellCommand();
            command.addExecuteScript(true, scriptPath);
            result = PowerShellExecutor.getExecutor().execute(workspace, command, this.logger);
            this.deleteScript(scriptPath);
        } else {
            this.logger.error("Script not found");
            result = false;
        }
        return result;
    }

    private void deleteScript(Path scriptPath) {
        try {
            scriptPath.toFile().delete();
        }
        catch (Exception ex) {
            this.logger.error("Delete operation is failed: " + ex.getMessage());
        }
    }

    void printStepStart() {
        this.logger.debug("\n===============================================================================\n===============================================================================\nStart Step:  " + this.stepId.toString() + "\n===============================================================================\n===============================================================================\n");
    }

    void printStepStop() {
        this.logger.debug("\n===============================================================================\n===============================================================================\nFinish Step:  " + this.stepId.toString() + "\n===============================================================================\n===============================================================================\n");
    }

    void printValidationErrors(List<ValidationError> validationErrors) {
        this.logger.debug("\n========= Validation Errors Start ============\n");
        this.logger.debug(validationErrors.toString());
        this.logger.debug("\n========= Validation Errors End   ============\n");
    }
}

