/*
 * Decompiled with CFR 0.152.
 */
package com.devart.dbforge.core;

import com.devart.dbforge.core.BaseLogger;
import com.devart.dbforge.core.BaseStep;
import com.devart.dbforge.core.BuildStepParamsValidator;
import com.devart.dbforge.core.Config;
import com.devart.dbforge.core.PackageProject;
import com.devart.dbforge.core.Parameters;
import com.devart.dbforge.core.PowerShellCommand;
import com.devart.dbforge.core.ProjectRepository;
import com.devart.dbforge.core.StepIds;
import com.devart.dbforge.core.ValidationError;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

class BuildStep
extends BaseStep {
    private BaseLogger logger;
    private String sourceFolderMode;
    private String subfolder;
    private PackageProject project;
    private Parameters parameters;

    BuildStep(Parameters parameters, BaseLogger logger) {
        super(parameters, logger);
        this.sourceFolderMode = parameters.sourceFolderMode;
        this.subfolder = parameters.subfolder;
        this.stepId = StepIds.Build;
        this.logger = logger;
        this.parameters = parameters;
    }

    @Override
    protected boolean createDatabase(Path workspace) {
        this.logger.debug("Remove items from the PackageProject list by id = " + this.packageId);
        ProjectRepository.getInstance().removePackageProject(this.packageId);
        this.logger.debug("Removed items from the PackageProject list by id = " + this.packageId);
        this.logger.debug("Create a new PackageProject");
        this.project = new PackageProject(this.packageId);
        this.logger.debug("Get the Script folder for the current workspace. workspace = " + workspace);
        String scriptFolder = this.getScriptFolder(workspace);
        this.logger.debug("Script folder = " + scriptFolder);
        this.logger.debug("Set SourceFolder for the project");
        this.project.setSourceFolder(scriptFolder);
        this.logger.debug("Create a database");
        return super.createDatabase(workspace);
    }

    @Override
    protected List<ValidationError> validate(Parameters parameters) {
        this.logger.debug(parameters.print());
        BuildStepParamsValidator validator = new BuildStepParamsValidator();
        List validationErrors = validator.checkBackend(parameters);
        this.printValidationErrors(validationErrors);
        return validationErrors;
    }

    @Override
    protected PowerShellCommand getPowerShellCommand(Path workspace) {
        PowerShellCommand command = new PowerShellCommand();
        if (this.connection == null) {
            this.logger.debug("connection == null");
        } else {
            this.logger.debug(this.connection.print());
        }
        command.addConnectionScript(this.connection);
        command.addDatabaseBuildScript(this.project, this.connection.getConnectionName(), this.compareOptions, this.sqlCompareFilter);
        this.logger.debug("Add a command to create a nuget package");
        command.addPackageInfo(this.project.getDatabaseProjectName(), this.project.getId(), null);
        command.addPublishDatabaseProject(this.project.getDatabaseProjectName(), null, workspace.toString(), null);
        return command;
    }

    @Override
    protected void dropDbAndDeleteDbInstance(Path workspace, boolean buildSuccessful) {
        super.dropDbAndDeleteDbInstance(workspace, buildSuccessful);
        if (buildSuccessful) {
            ProjectRepository.getInstance().addPackageProject(this.project);
        }
    }

    private String getScriptFolder(Path checkOutPath) {
        Path targetPath;
        if (this.sourceFolderMode.equals("vcsroot")) {
            this.logger.debug("sourceFolderMode = vcsroot, select the root directory");
            targetPath = checkOutPath;
        } else if (this.sourceFolderMode.equals("subfolder")) {
            this.logger.debug("sourceFolderMode = subfolder, select the subdirectory");
            targetPath = Paths.get(checkOutPath.toString(), this.subfolder);
        } else {
            String error = "Invalid sourceFolderMode = ".concat(this.sourceFolderMode);
            this.logger.error(error);
            throw new IllegalArgumentException(error);
        }
        return targetPath.toString();
    }

    @Override
    protected String getDisplayName() {
        return Config.getProperty((String)"BuildStepBuilder.DescriptorImpl.DisplayName");
    }

    @Override
    public boolean run() {
        boolean result;
        this.printStepStart();
        List<ValidationError> errors = this.validate(this.parameters);
        if (errors.size() > 0) {
            this.printValidationErrors(errors);
            result = false;
        } else {
            result = this.perform();
        }
        this.printStepStop();
        return result;
    }

    public static List<ValidationError> validateFrontendFields(Parameters parameters) {
        BuildStepParamsValidator validator = new BuildStepParamsValidator();
        List validationErrors = validator.checkFrontend(parameters);
        return validationErrors;
    }
}

