/*
 * Decompiled with CFR 0.152.
 */
package com.devart.dbforge.core;

import com.devart.dbforge.core.BaseLogger;
import com.devart.dbforge.core.PowerShellCommand;
import com.devart.dbforge.core.ProcessInfo;
import com.devart.dbforge.core.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Optional;

class PowerShellExecutor {
    private static PowerShellExecutor executor = new PowerShellExecutor();

    private PowerShellExecutor() {
    }

    static PowerShellExecutor getExecutor() {
        return executor;
    }

    private static String getPowerShellExeLocation() {
        String psHome = System.getenv("PS_HOME");
        if (psHome != null) {
            return psHome;
        }
        return "C:\\Windows\\System32\\WindowsPowerShell\\v1.0\\powershell.exe";
    }

    boolean execute(Path workspace, PowerShellCommand command, BaseLogger logger) {
        boolean success = false;
        Optional<Path> scriptPathOptional = Utils.generateScriptFile(workspace, command.toString(), ".ps1", logger);
        if (scriptPathOptional.isPresent()) {
            Path psScriptFile = scriptPathOptional.get();
            logger.debug("\n===============================================================================\nRun the file containing the PowerShell script\n===============================================================================\n");
            success = this.execute(workspace, psScriptFile, null, null, logger);
            logger.debug("\n===============================================================================\nPowerShell script executed with status = " + success + "\n===============================================================================\n");
            if (!success) {
                this.printErrorToLog(command, logger);
            }
            this.deleteFile(psScriptFile, logger);
        } else {
            logger.error("psScriptFile == null");
        }
        return success;
    }

    private void printErrorToLog(PowerShellCommand command, BaseLogger logger) {
        logger.message("Command execution failed:");
        logger.message(command.toString());
        logger.message("\n");
    }

    private void deleteFile(Path psScriptFile, BaseLogger logger) {
        try {
            psScriptFile.toFile().delete();
        }
        catch (Exception ex) {
            logger.error("Delete operation is failed: " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean execute(Path workspace, Path psScriptFile, String functionName, String[] functionParams, BaseLogger logger) {
        try {
            logger.message("Begin Execute command:");
            ProcessInfo processInfo = this.defineProcess(workspace, psScriptFile, functionName, functionParams, logger);
            boolean bl = this.executeProcess(processInfo, logger);
            return bl;
        }
        catch (IOException ex) {
            logger.error("Unexpected I/O exception executing PS script: " + ex.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ex) {
            logger.error("Unexpected thread interruption executing PS script" + ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            logger.message("Command Executed\n");
        }
    }

    private ProcessInfo defineProcess(Path workspace, Path scaRunnerLocation, String functionName, String[] functionParams, BaseLogger logger) {
        String cmdString = functionName == null ? this.generateCmdString(scaRunnerLocation.toString()) : this.generateCmdString(scaRunnerLocation.toString(), functionName, functionParams, logger);
        ProcessInfo processInfo = new ProcessInfo();
        processInfo.workdir = workspace;
        processInfo.cmdString = cmdString;
        return processInfo;
    }

    private String generateCmdString(String sqlCiLocation) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"").append(PowerShellExecutor.getPowerShellExeLocation()).append("\" -NonInteractive -ExecutionPolicy Bypass -File \"").append(sqlCiLocation).append("\"").append(" -Verbose");
        return stringBuilder.toString();
    }

    private String generateCmdString(String sqlCiLocation, String functionName, String[] functionParams, BaseLogger logger) {
        if (functionName == null) {
            return this.generateCmdString(sqlCiLocation);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"").append(PowerShellExecutor.getPowerShellExeLocation()).append("\"").append(" -NonInteractive -ExecutionPolicy Bypass -command \"& { . ").append(sqlCiLocation).append("; " + functionName);
        for (int i = 0; i < functionParams.length; ++i) {
            stringBuilder.append(" " + functionParams[i]);
        }
        stringBuilder.append("}\" -Verbose");
        logger.message(stringBuilder.toString());
        return stringBuilder.toString();
    }

    private boolean executeProcess(ProcessInfo processInfo, BaseLogger logger) throws IOException, InterruptedException {
        String command = processInfo.cmdString;
        File workdir = processInfo.workdir.toFile();
        logger.debug("Execute the command \n================\n" + command + "\n================\n");
        logger.debug("The working directory for the command = " + workdir);
        Process powerShellProcess = Runtime.getRuntime().exec(command, null, workdir);
        this.printScriptOutput(powerShellProcess, logger);
        int exitCode = powerShellProcess.waitFor();
        boolean success = exitCode == 0;
        logger.debug("Command completed: exit code = " + exitCode + "; success = " + success);
        return success;
    }

    private void printScriptOutput(Process powerShellProcess, BaseLogger logger) throws IOException {
        String line;
        logger.debug("Command output:");
        BufferedReader stdout = new BufferedReader(new InputStreamReader(powerShellProcess.getInputStream(), "CP866"));
        while ((line = stdout.readLine()) != null) {
            logger.debug(">> " + line);
        }
        stdout.close();
        logger.debug("Command error:");
        BufferedReader stderr = new BufferedReader(new InputStreamReader(powerShellProcess.getErrorStream(), "CP866"));
        while ((line = stderr.readLine()) != null) {
            logger.debug(">> " + line);
        }
        stderr.close();
        logger.debug("Execution of the command completed");
    }
}

