/*
 * Decompiled with CFR 0.152.
 */
package com.devart.dbforge.core;

import com.devart.dbforge.core.BaseLogger;
import com.devart.dbforge.core.BaseStep;
import com.devart.dbforge.core.Config;
import com.devart.dbforge.core.PackageProject;
import com.devart.dbforge.core.Parameters;
import com.devart.dbforge.core.PowerShellCommand;
import com.devart.dbforge.core.ProjectRepository;
import com.devart.dbforge.core.StepIds;
import com.devart.dbforge.core.SyncDatabaseInfo;
import com.devart.dbforge.core.SyncStepParamsValidator;
import com.devart.dbforge.core.ValidationError;
import java.nio.file.Path;
import java.util.List;

class SyncStep
extends BaseStep {
    private String transactionIsoLvl = "Serializable";
    private SyncDatabaseInfo syncDatabaseInfo;
    private BaseLogger logger;
    private Parameters parameters;

    SyncStep(Parameters parameters, BaseLogger logger) {
        super(parameters.setServerType("server"), logger);
        this.stepId = StepIds.Sync;
        this.transactionIsoLvl = parameters.transactionIsoLvl;
        this.logger = logger;
        this.parameters = parameters;
    }

    public static List<ValidationError> validateFrontendFields(Parameters parameters) {
        SyncStepParamsValidator validator = new SyncStepParamsValidator();
        List validationErrors = validator.checkFrontend(parameters);
        return validationErrors;
    }

    boolean createDatabase() {
        if (ProjectRepository.getInstance() == null) {
            this.logger.debug("ProjectRepository.getInstance() == null");
            return false;
        }
        if (ProjectRepository.getInstance().getPackageProject(this.packageId) == null) {
            this.logger.message(String.format(Config.getProperty((String)"packageMustBeBuilt"), this.packageId));
            return false;
        }
        this.syncDatabaseInfo = new SyncDatabaseInfo(this.compareOptions, this.transactionIsoLvl, this.sqlCompareFilter);
        return this.createDatabase(this.workspace);
    }

    @Override
    protected PowerShellCommand getPowerShellCommand(Path workspace) {
        PackageProject project = ProjectRepository.getInstance().getPackageProject(this.packageId);
        PowerShellCommand command = new PowerShellCommand();
        command.addConnectionScript(this.connection);
        command.addSyncDatabaseScript(project.getSourceFolder(), this.connection.getConnectionName(), this.syncDatabaseInfo);
        return command;
    }

    @Override
    protected String getDisplayName() {
        return Config.getProperty((String)"SyncStepBuilder.DescriptorImpl.DisplayName");
    }

    @Override
    public List<ValidationError> validate(Parameters parameters) {
        this.logger.debug(parameters.print());
        SyncStepParamsValidator validator = new SyncStepParamsValidator();
        List validationErrors = validator.checkBackend(parameters);
        return validationErrors;
    }

    @Override
    public boolean run() {
        boolean result;
        this.printStepStart();
        List<ValidationError> errors = this.validate(this.parameters);
        if (errors.size() > 0) {
            this.printValidationErrors(errors);
            result = false;
        } else {
            result = this.createDatabase() && this.perform();
        }
        this.printStepStop();
        return result;
    }
}

