/*
 * Decompiled with CFR 0.152.
 */
package com.devart.dbforge.core;

import com.devart.dbforge.core.BaseLogger;
import com.devart.dbforge.core.BaseStep;
import com.devart.dbforge.core.Config;
import com.devart.dbforge.core.PackageProject;
import com.devart.dbforge.core.Parameters;
import com.devart.dbforge.core.PowerShellCommand;
import com.devart.dbforge.core.ProjectRepository;
import com.devart.dbforge.core.RunTestInfo;
import com.devart.dbforge.core.StepIds;
import com.devart.dbforge.core.TestStepParamsValidator;
import com.devart.dbforge.core.ValidationError;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

class TestStep
extends BaseStep {
    private final String runTestMode;
    private final String runTests;
    private final BaseLogger logger;
    private boolean generateTestData;
    private String dgenFile;
    private RunTestInfo testInfo;
    private Parameters parameters;

    TestStep(Parameters parameters, BaseLogger logger) {
        super(parameters, logger);
        this.runTestMode = parameters.runTestMode;
        this.runTests = parameters.runTests;
        this.generateTestData = parameters.generateTestData;
        logger.debug("generateTestData=".concat(String.valueOf(parameters.generateTestData)));
        this.stepId = StepIds.Test;
        this.dgenFile = parameters.dgenFile;
        this.generateTestData = parameters.generateTestData;
        this.logger = logger;
        this.parameters = parameters;
    }

    @Override
    protected boolean createDatabase(Path workspace) {
        if (ProjectRepository.getInstance().getPackageProject(this.packageId) == null) {
            this.logger.message(String.format(Config.getProperty((String)"packageMustBeBuilt"), this.packageId));
            return false;
        }
        String outputReportFilename = new SimpleDateFormat("'dbforgeDevopsTestResults_'yyyyMMdd_HHmmss'.xml'").format(new Date());
        this.testInfo = new RunTestInfo(this.runTestMode.equals("runAll"), this.runTests, workspace.resolve(outputReportFilename).toString(), this.generateTestData, this.generateTestData ? Paths.get(workspace.toString(), this.dgenFile).toString() : "", this.compareOptions, this.sqlCompareFilter);
        return super.createDatabase(workspace);
    }

    @Override
    protected PowerShellCommand getPowerShellCommand(Path workspace) {
        PowerShellCommand command = new PowerShellCommand();
        PackageProject project = ProjectRepository.getInstance().getPackageProject(this.packageId);
        command.addConnectionScript(this.connection);
        command.addTestBuildScript(project.getSourceFolder(), this.connection.getConnectionName(), this.testInfo);
        return command;
    }

    @Override
    protected String getDisplayName() {
        return Config.getProperty((String)"TestStepBuilder.DescriptorImpl.DisplayName");
    }

    @Override
    public List<ValidationError> validate(Parameters parameters) {
        this.logger.debug(parameters.print());
        TestStepParamsValidator validator = new TestStepParamsValidator();
        List validationErrors = validator.checkBackend(parameters);
        this.printValidationErrors(validationErrors);
        return validationErrors;
    }

    @Override
    public boolean run() {
        boolean result;
        this.printStepStart();
        List<ValidationError> errors = this.validate(this.parameters);
        if (errors.size() > 0) {
            this.printValidationErrors(errors);
            result = false;
        } else {
            result = this.perform();
        }
        this.printStepStop();
        return result;
    }

    public static List<ValidationError> validateFrontendFields(Parameters parameters) {
        TestStepParamsValidator validator = new TestStepParamsValidator();
        List validationErrors = validator.checkFrontend(parameters);
        return validationErrors;
    }
}

