/*
 * Decompiled with CFR 0.152.
 */
package com.devart.dbforge.core;

import com.devart.dbforge.core.Config;
import com.devart.dbforge.core.ErrorType;
import com.devart.dbforge.core.Parameters;
import com.devart.dbforge.core.ValidationError;
import com.devart.dbforge.core.ValidatorUtils;
import java.util.ArrayList;
import java.util.List;

public final class SyncStepParamsValidator {
    public List<ValidationError> checkFrontend(Parameters parameters) {
        List<ValidationError> errors = this.doCheckPackageIdTemplate(parameters.packageId);
        errors.addAll(this.doCheckServer(parameters.server));
        if (parameters.authenticationType.equals("serverAuthentication")) {
            errors.addAll(this.doCheckDatabase(parameters.database));
            errors.addAll(this.doCheckUserName(parameters.userName));
        }
        return errors;
    }

    public List<ValidationError> checkBackend(Parameters parameters) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        errors.addAll(this.doCheckPackageId(parameters.packageId));
        return errors;
    }

    private List<ValidationError> doCheckPackageId(String value) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (ValidatorUtils.isEmpty(value)) {
            ValidationError error = new ValidationError("SYNC_STEP_PREFIX_packageId");
            error.errorType = ErrorType.error;
            error.message = Config.getProperty((String)"BuildStepBuilder.DescriptorImpl.errors.missingPackageId");
            errors.add(error);
            return errors;
        }
        if (!ValidatorUtils.isValidPackageId(value)) {
            ValidationError error = new ValidationError("SYNC_STEP_PREFIX_packageId");
            error.errorType = ErrorType.warning;
            error.message = Config.getProperty((String)"invalidPackageId");
            errors.add(error);
            return errors;
        }
        return errors;
    }

    private List<ValidationError> doCheckPackageIdTemplate(String value) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (ValidatorUtils.isEmpty(value)) {
            ValidationError error = new ValidationError("SYNC_STEP_PREFIX_packageId");
            error.errorType = ErrorType.error;
            error.message = Config.getProperty((String)"BuildStepBuilder.DescriptorImpl.errors.missingPackageId");
            errors.add(error);
            return errors;
        }
        if (!ValidatorUtils.isValidPackageIdTemplate(value)) {
            ValidationError error = new ValidationError("SYNC_STEP_PREFIX_packageId");
            error.errorType = ErrorType.warning;
            error.message = Config.getProperty((String)"invalidPackageId");
            errors.add(error);
            return errors;
        }
        return errors;
    }

    private List<ValidationError> doCheckServer(String value) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (ValidatorUtils.isEmpty(value)) {
            ValidationError error = new ValidationError("SYNC_STEP_PREFIX_server");
            error.errorType = ErrorType.error;
            error.message = Config.getProperty((String)"BuildStepBuilder.DescriptorImpl.errors.missingServer");
            errors.add(error);
            return errors;
        }
        return errors;
    }

    private List<ValidationError> doCheckDatabase(String value) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (ValidatorUtils.isEmpty(value)) {
            ValidationError error = new ValidationError("SYNC_STEP_PREFIX_database");
            error.errorType = ErrorType.error;
            error.message = Config.getProperty((String)"BuildStepBuilder.DescriptorImpl.errors.missingDatabase");
            errors.add(error);
            return errors;
        }
        return errors;
    }

    private List<ValidationError> doCheckUserName(String value) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (ValidatorUtils.isEmpty(value)) {
            ValidationError error = new ValidationError("SYNC_STEP_PREFIX_userName");
            error.errorType = ErrorType.warning;
            error.message = Config.getProperty((String)"BuildStepBuilder.DescriptorImpl.errors.missingUserName");
            errors.add(error);
            return errors;
        }
        return errors;
    }
}

