<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="props" tagdir="/WEB-INF/tags/props" %>
<%@ taglib prefix="l" tagdir="/WEB-INF/tags/layout" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="bs" tagdir="/WEB-INF/tags" %>

<jsp:useBean id="propertiesBean" scope="request" type="jetbrains.buildServer.controllers.BasePropertiesBean"/>
<jsp:useBean id="cons" class="com.devart.dbforge.core.BuildStepConstants"/>

<c:set var="SourceControlSection" value="Source-controlled database"/>
<c:set var="sourceFolderVcs" value="Database folder is in my build VCS root"/>
<c:set var="sourceFolderSubfolder" value="Database folder is a subfolder of my VCS root"/>
<c:set var="Subfolder" value="Subfolder location:"/>

<c:set var="SubfolderUsageDescr"
       value="Enter a path relative to your VCS root. For instance, if your script-folder is D:\\Repository\\Scripts, enter \\Scipts"/>

<c:set var="OutputPackageSection" value="Output package"/>
<c:set var="PackageId" value="Package ID:"/>
<c:set var="DatabaseServerSection" value="Temporary database server"/>
<c:set var="DatabaseServerSectionDescr"
       value="dbForge DevOps Automation for SQL Server will recreate and validate your database on a temporary server."/>
<c:set var="LocalDb" value="SQL LocalDB (recommended)"/>
<c:set var="SqlServer" value="SQL Server"/>
<c:set var="Server" value="Server:"/>
<c:set var="WindowsAuthentication" value="Windows authentication"/>
<c:set var="ServerAuthentication" value="SQL Server authentication"/>
<c:set var="UserName" value="User Name:"/>
<c:set var="Password" value="Password:"/>
<c:set var="Database" value="Temporary database:"/>
<c:set var="AdvancedSection" value="Advanced Options"/>
<c:set var="CompareOptions" value="Schema Compare options:"/>
<c:set var="SqlCompareFilter" value="Schema Compare filter:"/>


<c:set var="instance" value="<%=new Object()%>"/>

<link rel="stylesheet" type="text/css" href="${teamcityPluginResourcesPath}common.css" />
<%@ include file="Styles.jspf" %>
<%@ include file="Header.jspf" %>

<script type="text/javascript">
    (function () {
        BS.ShowHide = {

            showFields: function (sometimesHiddenItems) {
                sometimesHiddenItems.forEach(function (element) {
                    $(element).show();
                });
            },

            showSqlServerSettingsFields: function () {
                var radios = document.getElementsByClassName('${cons.authenticationType}');
                for (var i = 0, length = radios.length; i < length; i++) {
                    if (radios[i].checked) {
                        if (radios[i].value == "serverAuthentication") {
                            BS.ShowHide.showFields(['Server', 'Database', 'AuthenticationType', 'UserName', 'Password']);
                        } else {
                            BS.ShowHide.showFields(['Server', 'Database', 'AuthenticationType']);
                        }
                        break;
                    }
                }
            },

            hideFields: function (sometimesHiddenItems) {
                sometimesHiddenItems.forEach(function (element) {
                    $(element).hide();
                });
            }
        };

    })();
</script>

<l:settingsGroup title="${SourceControlSection}">
    <c:set var="showSettings" value="${propertiesBean.properties[cons.sourceFolderMode].equals('subfolder')}"/>
    <tr>
        <th><label for="${cons.sourceFolderMode}">Database folder:</label></th>
        <td>

            <props:radioButtonProperty
                    name="${cons.sourceFolderMode}"
                    value="vcsroot"
                    onclick="BS.ShowHide.hideFields(['subfolder1'])"
                    checked="true"
            />
            <label for="${cons.sourceFolderMode}">${sourceFolderVcs}</label>
            <br/>
            <props:radioButtonProperty
                    name="${cons.sourceFolderMode}"
                    value="subfolder"
                    onclick="BS.ShowHide.showFields(['subfolder1'])"
            />
            <label for="${cons.sourceFolderMode}">${sourceFolderSubfolder}</label>
            <br/>
        </td>
    </tr>

    <tr id="subfolder1" style="${showSettings ? '' : 'display: none;'}">

        <th><label for="${cons.subfolder}">${Subfolder}<l:star/></label></th>
        <td>
            <props:textProperty name="${cons.subfolder}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note">${SubfolderUsageDescr}</span>
            <span class="error" id="error_${cons.subfolder}"></span>
        </td>
    </tr>
</l:settingsGroup>

<l:settingsGroup title="${OutputPackageSection}">
    <tr>
        <th><label for="${cons.packageId}">${PackageId}<l:star/></label></th>
        <td>
            <props:textProperty name="${cons.packageId}" className="longField" maxlength="100"/>
            <span class="smallNote"></span>
            <span class="note">Specify a unique package name that will also be used in other build steps.</span>
            <span class="error" id="error_${cons.packageId}"></span>
        </td>
    </tr>
</l:settingsGroup>

<l:settingsGroup title="${DatabaseServerSection}">

    <tr>
        <td colspan="2">
            <div>${DatabaseServerSectionDescr}</div>
        </td>
    </tr>

    <c:set var="showSqlServerSettings" value="${propertiesBean.properties[cons.serverType].equals('server')}"/>

    <tr>
        <th><label for="${cons.serverType}">Database</label></th>
        <td>
            <props:radioButtonProperty
                    name="${cons.serverType}"
                    value="localDb"
                    onclick="BS.ShowHide.hideFields(['Server', 'Database', 'AuthenticationType', 'UserName', 'Password'])"
                    checked="true"
            />
            <label for="${cons.serverType}">${LocalDb}</label>
            <br/>
            <props:radioButtonProperty
                    name="${cons.serverType}"
                    value="server"
                    onclick="BS.ShowHide.showSqlServerSettingsFields()"
            />
            <label for="${cons.serverType}">${SqlServer}</label>
            <br/>
        </td>
    </tr>

    <tr id="Server" style="${showSqlServerSettings ? '' : 'display: none;'}">

        <th><label for="${cons.server}">${Server}<l:star/></label></th>
        <td>
            <props:textProperty name="${cons.server}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note"></span>
            <span class="error" id="error_${cons.server}"></span>
        </td>
    </tr>

    <tr id="Database" style="${showSqlServerSettings ? '' : 'display: none;'}">
        <th><label for="${cons.database}">${Database}<l:star/></label></th>
        <td>
            <props:textProperty name="${cons.database}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note"></span>
            <span class="error" id="error_${cons.database}"></span>
        </td>
    </tr>

    <c:set var="showServerAuthenticationSettings"
           value="${propertiesBean.properties[cons.authenticationType].equals('serverAuthentication')}"/>
    <tr id="AuthenticationType" style="${showSqlServerSettings ? '' : 'display: none;'}">
        <td>
            <props:radioButtonProperty
                    name="${cons.authenticationType}"
                    value="windowsAuthentication"
                    onclick="BS.ShowHide.hideFields(['UserName', 'Password'])"
                    className="${cons.authenticationType}"
                    checked="true"
            />
            <label for="${cons.authenticationType}">${WindowsAuthentication}</label>
            <br/>
            <props:radioButtonProperty
                    name="${cons.authenticationType}"
                    value="serverAuthentication"
                    onclick="BS.ShowHide.showFields(['UserName', 'Password'])"
                    className="${cons.authenticationType}"
            />
            <label for="${cons.authenticationType}">${ServerAuthentication}</label>
            <br/>
        </td>
    </tr>

    <tr id="UserName" style="${showServerAuthenticationSettings ? '' : 'display: none;'}">
        <th><label for="${cons.userName}">${UserName}<l:star/></label></th>
        <td>
            <props:textProperty name="${cons.userName}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note"></span>
            <span class="error" id="error_${cons.userName}"></span>
        </td>
    </tr>

    <tr id="Password" style="${showServerAuthenticationSettings ? '' : 'display: none;'}">

        <th><label for="${cons.password}">${Password}</label></th>
        <td>
            <props:textProperty name="${cons.password}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note"></span>
            <span class="error" id="error_${cons.password}"></span>
        </td>
    </tr>

</l:settingsGroup>

<l:settingsGroup title="${AdvancedSection}" className="advancedSetting">
    <tr id="CompareOptions" class="advancedSetting">
        <th><label for="${cons.compareOptions}">${CompareOptions}</label></th>
        <td>
            <props:textProperty name="${cons.compareOptions}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note"></span>
            <span class="error" id="error_${cons.compareOptions}"></span>
        </td>
    </tr>

    <tr id="SqlCompareFilter" class="advancedSetting">
        <th><label for="${cons.sqlCompareFilter}">${SqlCompareFilter}</label></th>
        <td>
            <props:textProperty name="${cons.sqlCompareFilter}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note">Specifies a path to an alternative filter file which will be used for validating the schema to override *.scflt filter file present in the input.</span>
            <span class="error" id="error_${cons.sqlCompareFilter}"></span>
        </td>
    </tr>
</l:settingsGroup>
