<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="props" tagdir="/WEB-INF/tags/props" %>
<%@ taglib prefix="l" tagdir="/WEB-INF/tags/layout" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="bs" tagdir="/WEB-INF/tags" %>
<jsp:useBean id="propertiesBean" scope="request" type="jetbrains.buildServer.controllers.BasePropertiesBean"/>
<jsp:useBean id="cons" class="com.devart.dbforge.core.SyncStepConstants"/>
<jsp:useBean id="transactionIsoLvl" class="com.devart.dbforge.core.TransactionIsoLvl"/>

<c:set var="DatabasePackageSection" value="Database package to sync"/>
<c:set var="DatabasePackageSectionDesc"
       value="Enter the ID of the package that you want to use to update the target database. The ID must be for a package built by dbForge DevOps Automation for SQL Server."/>
<c:set var="PackageId" value="Package ID:"/>
<c:set var="TargetDatabaseSection" value="Target database"/>
<c:set var="TargetDatabaseSectionDescr"
       value="dbForge DevOps Automation for SQL Server will update the target database you specify here."/>
<c:set var="Server" value="Server:"/>
<c:set var="Database" value="Database:"/>
<c:set var="WindowsAuthentication" value="Windows authentication"/>
<c:set var="ServerAuthentication" value="SQL Server authentication"/>
<c:set var="UserName" value="User Name:"/>
<c:set var="Password" value="Password:"/>
<c:set var="AdvancedSection" value="Advanced Options"/>
<c:set var="TransactionIsoLvl" value="Transaction isolation level:"/>
<c:set var="CompareOptions" value="Schema Compare options:"/>
<c:set var="SqlCompareFilter" value="Schema Compare filter:"/>

<link rel="stylesheet" type="text/css" href="${teamcityPluginResourcesPath}common.css" />
<%@ include file="Styles.jspf" %>
<%@ include file="Header.jspf" %>

<script type="text/javascript">
    (function () {
        BS.ShowHide = {

            showFields: function (sometimesHiddenItems) {
                sometimesHiddenItems.forEach(function (element) {
                    console.log(element);
                    $(element).show();
                });
            },

            hideFields: function (sometimesHiddenItems) {
                sometimesHiddenItems.forEach(function (element) {
                    console.log(element);
                    $(element).hide();
                });
            }
        };
    })();
</script>

<l:settingsGroup title="${DatabasePackageSection}">
    <tr>
        <td colspan="2">
            <div>${DatabasePackageSectionDesc}</div>
        </td>
    </tr>
    <tr>
        <th><label for="${cons.packageId}">${PackageId}<l:star/></label></th>
        <td>
            <props:textProperty name="${cons.packageId}" className="longField" maxlength="100"/>
            <span class="smallNote"></span>
            <span class="note">Specify a unique package name that will also be used in other build steps.</span>
            <span class="error" id="error_${cons.packageId}"></span>
        </td>
    </tr>
</l:settingsGroup>

<l:settingsGroup title="${TargetDatabaseSection}">
    <tr>
        <td colspan="2">
            <div>${TargetDatabaseSectionDescr}</div>
        </td>
    </tr>
    <tr id="Server">
        <th><label for="${cons.server}">${Server}<l:star/></label></th>
        <td>
            <props:textProperty name="${cons.server}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note"></span>
            <span class="error" id="error_${cons.server}"></span>
        </td>
    </tr>

    <tr id="Database">
        <th><label for="${cons.database}">${Database}<l:star/></label></th>
        <td>
            <props:textProperty name="${cons.database}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note"></span>
            <span class="error" id="error_${cons.database}"></span>
        </td>
    </tr>

    <c:set var="showAuthenticationSettings"
           value="${propertiesBean.properties[cons.authenticationType].equals('serverAuthentication')}"/>

    <tr>
        <td>
            <props:radioButtonProperty
                    name="${cons.authenticationType}"
                    value="windowsAuthentication"
                    onclick="BS.ShowHide.hideFields(['UserName', 'Password'])"
                    checked="true"
            />
            <label for="${cons.authenticationType}">${WindowsAuthentication}</label>
            <br/>
            <props:radioButtonProperty
                    name="${cons.authenticationType}"
                    value="serverAuthentication"
                    onclick="BS.ShowHide.showFields(['UserName', 'Password'])"
            />
            <label for="${cons.authenticationType}">${ServerAuthentication}</label>
            <br/>
        </td>
    </tr>

    <tr id="UserName" style="${showAuthenticationSettings ? '' : 'display: none;'}">
        <th><label for="${cons.userName}">${UserName}<l:star/></label></th>
        <td>
            <props:textProperty name="${cons.userName}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note"></span>
            <span class="error" id="error_${cons.userName}"></span>
        </td>
    </tr>

    <tr id="Password" style="${showAuthenticationSettings ? '' : 'display: none;'}">

        <th><label for="${cons.password}">${Password}</label></th>
        <td>
            <props:textProperty name="${cons.password}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note"></span>
            <span class="error" id="error_${cons.password}"></span>
        </td>
    </tr>
</l:settingsGroup>
<l:settingsGroup title="${AdvancedSection}" className="advancedSetting">
    <tr id="CompareOptions" class="advancedSetting">
        <th><label for="${cons.compareOptions}">${CompareOptions}</label></th>
        <td>
            <props:textProperty name="${cons.compareOptions}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note"></span>
            <span class="error" id="error_${cons.compareOptions}"></span>
        </td>
    </tr>
    <tr id="TransactionIsoLvl" class="advancedSetting">
        <th><label for="${cons.transactionIsoLvl}">${TransactionIsoLvl}<l:star/></label></th>
        <td>
            <props:selectProperty name="${cons.transactionIsoLvl}" className="mediumField">
                <props:option value="${transactionIsoLvl.serializable}">Serializable</props:option>
                <props:option value="${transactionIsoLvl.snapshot}">Snapshot</props:option>
                <props:option
                        value="${transactionIsoLvl.repeatableRead}">Repeatable Read</props:option>
                <props:option
                        value="${transactionIsoLvl.readCommitted}">Read Committed</props:option>
                <props:option
                        value="${transactionIsoLvl.readUncommitted}">Read Uncommitted</props:option>
            </props:selectProperty>
            <span class="error" id="error_${cons.transactionIsoLvl}"></span>
        </td>
    </tr>
    <tr id="SqlCompareFilter" class="advancedSetting">
        <th><label for="${cons.sqlCompareFilter}">${SqlCompareFilter}</label></th>
        <td>
            <props:textProperty name="${cons.sqlCompareFilter}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note">Specifies a path to an alternative filter file which will be used for validating the schema to override *.scflt filter file present in the input.</span>
            <span class="error" id="error_${cons.sqlCompareFilter}"></span>
        </td>
    </tr>
</l:settingsGroup>