/*
 * Decompiled with CFR 0.152.
 */
package com.devart.dbforge.core;

import com.devart.dbforge.core.BaseLogger;
import com.devart.dbforge.core.ComponentInfo;
import com.devart.dbforge.core.PowerShellExecutor;
import com.devart.dbforge.core.StepIds;
import com.devart.dbforge.core.StepInfo;
import com.devart.dbforge.core.Utils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class EnvironmentValidator {
    private final BaseLogger logger;

    EnvironmentValidator(BaseLogger logger) {
        this.logger = logger;
    }

    boolean validate(Path workspace, List<StepInfo> steps) {
        try {
            Map<StepIds, ArrayList<ComponentInfo>> componentsOfSteps = this.getComponentsOfSteps(steps);
            Map<String, ComponentInfo> componentsForCheck = this.getComponentsForCheck(steps, componentsOfSteps);
            ArrayList<String> failedComponents = new ArrayList<String>();
            Path scriptLocation = Utils.copyResourceToWorkspace(workspace, "PowerShell/DbForgeScripts.ps1", this.logger);
            String psComponentFailedDescription = this.checkPowerShellInstalled(workspace, scriptLocation);
            if (!PowerShellExecutor.getExecutor().execute(workspace, scriptLocation, "CheckRequiredComponentInstall", ComponentInfo.GetStudioInfo().GetPSCallingParams(), this.logger)) {
                failedComponents.addAll(this.\u0441heckComponentsAreInstalled(workspace, componentsForCheck, scriptLocation));
            }
            this.writeFailedComponentsListToLog(psComponentFailedDescription, failedComponents);
            return psComponentFailedDescription == null && failedComponents.isEmpty();
        }
        catch (IOException ex) {
            this.logger.error("Unexpected I/O exception executing cmdlet: " + ex.getMessage());
            return false;
        }
    }

    private List<String> \u0441heckComponentsAreInstalled(Path workspace, Map<String, ComponentInfo> checkComponents, Path scriptLocation) {
        ArrayList<String> failedComponents = new ArrayList<String>();
        for (Map.Entry<String, ComponentInfo> entry : checkComponents.entrySet()) {
            if (PowerShellExecutor.getExecutor().execute(workspace, scriptLocation, "CheckRequiredComponentInstall", entry.getValue().GetPSCallingParams(), this.logger)) continue;
            failedComponents.add(String.format("%s, ver. %s", entry.getValue().GetComponentName(), entry.getValue().GetComponentVersion()));
        }
        return failedComponents;
    }

    private String checkPowerShellInstalled(Path workspace, Path scriptLocation) {
        if (!PowerShellExecutor.getExecutor().execute(workspace, scriptLocation, "CheckPowerShellInstall", new String[]{"Devart.DbForge.DevOpsAutomation.SqlServer", "1.1.1"}, this.logger)) {
            return String.format("%s, ver. %s", "dbForge DevOps Automation PowerShell for SQL Server", "1.1.1");
        }
        return null;
    }

    private void writeFailedComponentsListToLog(String psComponentFailedDescription, List<String> failedComponentNames) {
        if (psComponentFailedDescription == null && failedComponentNames.size() == 0) {
            return;
        }
        this.logger.message("The dbForge DevOps Automation for SQL Server plugin requires the following components to be installed:");
        this.logger.message("\r\n");
        if (psComponentFailedDescription != null) {
            this.logger.message("\t" + psComponentFailedDescription);
        }
        if (failedComponentNames.size() > 0) {
            for (String name : failedComponentNames) {
                this.logger.message("\t" + name);
            }
            this.logger.message("\tor");
            this.logger.message("\t" + String.format("%s Enterprise edition, ver. %s", ComponentInfo.GetStudioInfo().GetComponentName(), ComponentInfo.GetStudioInfo().GetComponentVersion()));
        }
        this.logger.message("\r\n");
        this.logger.message("You can download these products at:\nhttps://www.devart.com/dbforge/sql/sql-tools/download.html\nhttps://www.devart.com/dbforge/sql/studio/download.html");
    }

    private Map<String, ComponentInfo> getComponentsForCheck(List<StepInfo> stepInfos, Map<StepIds, ArrayList<ComponentInfo>> stepComponentParams) {
        HashMap<String, ComponentInfo> checkComponents = new HashMap<String, ComponentInfo>();
        for (int i = 0; i < stepInfos.size(); ++i) {
            StepIds stepId = stepInfos.get((int)i).stepId;
            if (stepId == null || !stepComponentParams.keySet().contains(stepId)) continue;
            List listStepComponents = stepComponentParams.get(stepId);
            for (int j = 0; j < listStepComponents.size(); ++j) {
                if (checkComponents.containsKey(((ComponentInfo)listStepComponents.get(j)).GetId())) continue;
                checkComponents.put(((ComponentInfo)listStepComponents.get(j)).GetId(), (ComponentInfo)listStepComponents.get(j));
            }
        }
        return checkComponents;
    }

    private Map<StepIds, ArrayList<ComponentInfo>> getComponentsOfSteps(List<StepInfo> steps) {
        HashMap<StepIds, ArrayList<ComponentInfo>> stepComponents = new HashMap<StepIds, ArrayList<ComponentInfo>>();
        ArrayList<ComponentInfo> components = this.getBuildStepComponents();
        stepComponents.put(StepIds.Build, components);
        components = this.getExecuteStepComponents();
        stepComponents.put(StepIds.Execute, components);
        components = this.getTestStepComponents();
        if (steps.stream().anyMatch(step -> step.stepId == StepIds.Test && step.parameters.generateTestData)) {
            components.add(ComponentInfo.GetComponentInfo((String)"DevartDataGeneratorMSSql_is1"));
        }
        stepComponents.put(StepIds.Test, components);
        return stepComponents;
    }

    private ArrayList<ComponentInfo> getTestStepComponents() {
        ArrayList<ComponentInfo> components = new ArrayList<ComponentInfo>();
        ComponentInfo component = ComponentInfo.GetComponentInfo((String)"DevartUnitTest_is1");
        components.add(component);
        return components;
    }

    private ArrayList<ComponentInfo> getBuildStepComponents() {
        ArrayList<ComponentInfo> components = new ArrayList<ComponentInfo>();
        ComponentInfo component = ComponentInfo.GetComponentInfo((String)"DevartSchemaCompareMSSql_is1");
        components.add(component);
        return components;
    }

    private ArrayList<ComponentInfo> getExecuteStepComponents() {
        ArrayList<ComponentInfo> components = new ArrayList<ComponentInfo>();
        ComponentInfo component = ComponentInfo.GetComponentInfo((String)"DevartSchemaCompareMSSql_is1");
        components.add(component);
        return components;
    }
}

