/*
 * Decompiled with CFR 0.152.
 */
package com.devart.dbforge.core;

import com.devart.dbforge.core.BaseLogger;
import com.devart.dbforge.core.BaseStep;
import com.devart.dbforge.core.Config;
import com.devart.dbforge.core.ExecuteStepParamsValidator;
import com.devart.dbforge.core.Parameters;
import com.devart.dbforge.core.PowerShellCommand;
import com.devart.dbforge.core.StepIds;
import com.devart.dbforge.core.ValidationError;
import java.nio.file.Path;
import java.util.List;

class ExecuteStep
extends BaseStep {
    private BaseLogger logger;
    private Parameters parameters;
    private final String filesToExecute;
    private final String fileEncoding;
    private final String zipPassword;
    private final Boolean ignoreError;

    ExecuteStep(Parameters parameters, BaseLogger logger) {
        super(parameters.setServerType("server"), logger);
        this.stepId = StepIds.Execute;
        this.filesToExecute = parameters.filesToExecute;
        this.fileEncoding = parameters.fileEncoding;
        this.zipPassword = parameters.zipPassword;
        this.ignoreError = parameters.ignoreError;
        this.logger = logger;
        this.parameters = parameters;
    }

    public static List<ValidationError> validateFrontendFields(Parameters parameters) {
        ExecuteStepParamsValidator validator = new ExecuteStepParamsValidator();
        List validationErrors = validator.checkFrontend(parameters);
        return validationErrors;
    }

    @Override
    protected PowerShellCommand getPowerShellCommand(Path workspace) {
        PowerShellCommand command = new PowerShellCommand();
        command.addConnectionScript(this.connection);
        command.addDatabaseExecuteScript(this.connection.getConnectionName(), this.filesToExecute, this.fileEncoding, this.zipPassword, this.ignoreError);
        return command;
    }

    @Override
    protected String getDisplayName() {
        return Config.getProperty((String)"ExecuteStepBuilder.DescriptorImpl.DisplayName");
    }

    @Override
    public List<ValidationError> validate(Parameters parameters) {
        this.logger.debug(this.parametersToString(parameters));
        ExecuteStepParamsValidator validator = new ExecuteStepParamsValidator();
        List validationErrors = validator.checkBackend(parameters);
        return validationErrors;
    }

    @Override
    public boolean run() {
        boolean result;
        this.printStepStart();
        List<ValidationError> errors = this.validate(this.parameters);
        if (errors.size() > 0) {
            this.printValidationErrors(errors);
            result = false;
        } else {
            result = this.perform();
        }
        this.printStepStop();
        return result;
    }

    @Override
    protected String parametersToString(Parameters parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.parametersToString(parameters)).append("param.filesToExecute = \"").append(parameters.filesToExecute).append("\";\n").append("param.fileEncoding = \"").append(parameters.fileEncoding).append("\";\n").append("param.zipPassword = \"*****\";\n").append("param.ignoreError = \"").append(parameters.ignoreError).append("\";\n");
        return sb.toString();
    }
}

