/*
 * Decompiled with CFR 0.152.
 */
package com.devart.dbforge.core;

import com.devart.dbforge.core.Parameters;
import com.devart.dbforge.core.ValidatorUtils;
import java.io.File;
import java.util.Map;

class ParametersBuilder {
    public static final String EMPTY = "";

    ParametersBuilder() {
    }

    public static String defaultIfEmptyAndTrim(String str) {
        return ValidatorUtils.isEmpty((String)str) ? EMPTY : str.trim();
    }

    public static Parameters fillBuildStepParams(Map<String, String> runnerParams, File workdir) {
        Parameters params = new Parameters();
        params.sourceFolderMode = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("BUILD_STEP_PREFIX_sourceFolderMode"));
        params.subfolder = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("BUILD_STEP_PREFIX_subfolder"));
        params.serverType = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("BUILD_STEP_PREFIX_serverType"));
        params.authenticationType = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("BUILD_STEP_PREFIX_authenticationType"));
        params.server = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("BUILD_STEP_PREFIX_server"));
        params.database = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("BUILD_STEP_PREFIX_database"));
        params.userName = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("BUILD_STEP_PREFIX_userName"));
        params.password = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("BUILD_STEP_PREFIX_password"));
        params.packageId = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("BUILD_STEP_PREFIX_packageId"));
        params.compareOptions = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("BUILD_STEP_PREFIX_compareOptions"));
        params.sqlCompareFilter = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("BUILD_STEP_PREFIX_sqlCompareFilter"));
        params.overridePackageVersion = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("BUILD_STEP_PREFIX_overridePackageVersion"));
        params.transactionIsoLvl = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("BUILD_STEP_PREFIX_transactionIsoLvl"));
        params.outputFolder = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("BUILD_STEP_PREFIX_outputFolder"));
        params.overrideQueryTimeout = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("BUILD_STEP_PREFIX_overrideQueryTimeout"));
        if (workdir != null) {
            params.workspace = workdir.toPath();
        }
        return params;
    }

    public static Parameters fillExecuteStepParams(Map<String, String> runnerParams, File workdir) {
        Parameters params = new Parameters();
        params.serverType = "server";
        params.server = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("EXECUTE_STEP_PREFIX_server"));
        params.database = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("EXECUTE_STEP_PREFIX_database"));
        params.authenticationType = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("EXECUTE_STEP_PREFIX_authenticationType"));
        params.userName = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("EXECUTE_STEP_PREFIX_userName"));
        params.password = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("EXECUTE_STEP_PREFIX_password"));
        params.filesToExecute = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("EXECUTE_STEP_PREFIX_filesToExecute"));
        params.fileEncoding = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("EXECUTE_STEP_PREFIX_fileEncoding"));
        params.zipPassword = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("EXECUTE_STEP_PREFIX_zipPassword"));
        params.ignoreError = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("EXECUTE_STEP_PREFIX_ignoreError")).equals("true");
        if (workdir != null) {
            params.workspace = workdir.toPath();
        }
        return params;
    }

    public static Parameters fillTestStepParams(Map<String, String> runnerParams, File workdir) {
        Parameters params = new Parameters();
        params.packageId = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("TEST_STEP_PREFIX_packageId"));
        params.serverType = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("TEST_STEP_PREFIX_serverType"));
        params.server = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("TEST_STEP_PREFIX_server"));
        params.database = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("TEST_STEP_PREFIX_database"));
        params.authenticationType = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("TEST_STEP_PREFIX_authenticationType"));
        params.userName = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("TEST_STEP_PREFIX_userName"));
        params.password = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("TEST_STEP_PREFIX_password"));
        params.runTestMode = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("TEST_STEP_PREFIX_runTestMode"));
        params.runTests = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("TEST_STEP_PREFIX_runTests"));
        params.generateTestData = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("TEST_STEP_PREFIX_generateTestData")).equals("true");
        params.dgenFile = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("TEST_STEP_PREFIX_dgenFile"));
        params.compareOptions = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("TEST_STEP_PREFIX_compareOptions"));
        params.sqlCompareFilter = ParametersBuilder.defaultIfEmptyAndTrim(runnerParams.get("TEST_STEP_PREFIX_sqlCompareFilter"));
        if (workdir != null) {
            params.workspace = workdir.toPath();
        }
        return params;
    }

    public static Parameters fillSyncStepParams(Map<String, String> rawParams, File workdir) {
        Parameters params = new Parameters();
        params.authenticationType = ParametersBuilder.defaultIfEmptyAndTrim(rawParams.get("SYNC_STEP_PREFIX_authenticationType"));
        params.server = ParametersBuilder.defaultIfEmptyAndTrim(rawParams.get("SYNC_STEP_PREFIX_server"));
        params.database = ParametersBuilder.defaultIfEmptyAndTrim(rawParams.get("SYNC_STEP_PREFIX_database"));
        params.userName = ParametersBuilder.defaultIfEmptyAndTrim(rawParams.get("SYNC_STEP_PREFIX_userName"));
        params.password = ParametersBuilder.defaultIfEmptyAndTrim(rawParams.get("SYNC_STEP_PREFIX_password"));
        params.packageId = ParametersBuilder.defaultIfEmptyAndTrim(rawParams.get("SYNC_STEP_PREFIX_packageId"));
        params.compareOptions = ParametersBuilder.defaultIfEmptyAndTrim(rawParams.get("SYNC_STEP_PREFIX_compareOptions"));
        params.transactionIsoLvl = ParametersBuilder.defaultIfEmptyAndTrim(rawParams.get("SYNC_STEP_PREFIX_transactionIsoLvl"));
        params.sqlCompareFilter = ParametersBuilder.defaultIfEmptyAndTrim(rawParams.get("SYNC_STEP_PREFIX_sqlCompareFilter"));
        if (workdir != null) {
            params.workspace = workdir.toPath();
        }
        return params;
    }
}

