/*
 * Decompiled with CFR 0.152.
 */
package com.devart.dbforge.core;

import com.devart.dbforge.core.ConnectionInfo;
import com.devart.dbforge.core.PackageProject;
import com.devart.dbforge.core.RunTestInfo;
import com.devart.dbforge.core.ScriptParams;
import com.devart.dbforge.core.SyncDatabaseInfo;
import com.devart.dbforge.core.Utils;
import com.devart.dbforge.core.ValidatorUtils;
import java.nio.file.Path;
import java.util.regex.Pattern;

class PowerShellCommand {
    static final String separator = ";";
    private StringBuilder sb = new StringBuilder();
    private static final String scriptTemplate = "try{%s%n}%ncatch  { Write-Host $_.Exception.Message -ForegroundColor Red; [System.Environment]::Exit(1); }";
    private static final Pattern passwordTemplatePattern = Pattern.compile("(?<prefix> -(?>Zip)?Password \"?)([^;\"]+)");

    PowerShellCommand() {
    }

    void addConnectionScript(ConnectionInfo connection) {
        this.sb.append(String.format("%n$%s = New-DevartSqlDatabaseConnection -Server \"%s\" -Database \"%s\"", connection.getConnectionName(), connection.getServer(), connection.getDatabase()));
        if (connection.getIsWindowsAuthentication()) {
            this.sb.append(" -WindowsAuthentication");
        } else {
            this.sb.append(String.format(" -UserName %s", connection.getUserName()));
            if (ValidatorUtils.isNotEmpty((String)connection.getPassword())) {
                this.sb.append(String.format(" -Password %s", connection.getPassword()));
            }
        }
        this.addScriptSeparator();
    }

    void addDatabaseBuildScript(PackageProject project, String connectionName, ScriptParams scriptParams) {
        String compareOptions = scriptParams.getCompareOptions();
        String sqlCompareFilter = scriptParams.getSqlCompareFilter();
        String overrideQueryTimeout = scriptParams.getOverrideQueryTimeout();
        String outputFolder = scriptParams.getOutputFolder();
        String overridePackageVersion = scriptParams.getOverridePackageVersion();
        String transactionIsoLvl = scriptParams.getTransactionIsoLvl();
        this.sb.append(String.format("%n$%s = Invoke-DevartDatabaseBuild -SourceScriptsFolder \"%s\" -Connection $%s", project.getDatabaseProjectName(), project.getSourceFolder(), connectionName));
        if (ValidatorUtils.isNotEmpty((String)sqlCompareFilter)) {
            String part = String.format(" -FilterPath \"%s\"", sqlCompareFilter);
            this.sb.append(part);
        }
        if (ValidatorUtils.isNotEmpty((String)compareOptions)) {
            this.sb.append(String.format(" -SynchronizationOptions \"%s\"", compareOptions));
        }
        if (ValidatorUtils.isNotEmpty((String)overrideQueryTimeout)) {
            this.sb.append(String.format(" -QueryBatchTimeout \"%s\"", overrideQueryTimeout));
        }
        if (ValidatorUtils.isNotEmpty((String)overrideQueryTimeout)) {
            this.sb.append(String.format(" -TransactionIsolationLevel \"%s\"", transactionIsoLvl));
        }
        this.addScriptSeparator();
        this.sb.append(String.format("%nif(-Not $%s.Valid) { [System.Environment]::Exit(1); }", project.getDatabaseProjectName()));
    }

    public void addDatabaseExecuteScript(String connectionName, String filesToExecute, String fileEncoding, String zipPassword, Boolean ignoreError) {
        this.sb.append(String.format("%n$result = Invoke-DevartExecuteScript  -Connection $%s -Input \"%s\"", connectionName, filesToExecute));
        if (!fileEncoding.isEmpty()) {
            this.sb.append(String.format(" -Encoding \"%s\"", fileEncoding));
        }
        if (!zipPassword.isEmpty()) {
            this.sb.append(String.format(" -ZipPassword \"%s\"", zipPassword));
        }
        if (ignoreError.booleanValue()) {
            this.sb.append(" -IgnoreError");
        }
        this.addScriptSeparator();
        this.sb.append(String.format("%nif(-Not $result) { [System.Environment]::Exit(1); }", new Object[0]));
    }

    void addTestBuildScript(String scriptFolder, String connectionName, RunTestInfo testInfo) {
        String sqlCompareFilter;
        this.sb.append(String.format("%n$result = Invoke-DevartDatabaseTests -InputObject \"%s\" -TemporaryDatabaseServer $%s -OutReportFileName:\"%s\" -ReportFormat %s -RewriteReport", scriptFolder, connectionName, testInfo.getOutputReport(), testInfo.getOutputReportFormat()));
        if (testInfo.getInstallFramework()) {
            this.sb.append(String.format(" -InstalltSQLtFramework -UnInstalltSQLtFramework", new Object[0]));
        }
        if (testInfo.getGenerateTestData()) {
            String part = String.format(" -IncludeTestData -DataGeneratorProject \"%s\"", testInfo.getDgenFile());
            this.sb.append(part);
        }
        if (!testInfo.getRunEveryTests()) {
            this.sb.append(String.format(" -UnitTests %s", "\"" + testInfo.getRunTests() + "\""));
        }
        if (ValidatorUtils.isNotEmpty((String)(sqlCompareFilter = testInfo.getSqlCompareFilter()))) {
            String part = String.format(" -FilterPath \"%s\"", sqlCompareFilter);
            this.sb.append(part);
        }
        if (ValidatorUtils.isNotEmpty((String)testInfo.getCompareOptions())) {
            this.sb.append(String.format(" -SynchronizationOptions \"%s\"", testInfo.getCompareOptions()));
        }
        this.addScriptSeparator();
        this.sb.append(String.format("%nif(-Not $result) { [System.Environment]::Exit(1); }", new Object[0]));
    }

    void addSyncDatabaseScript(String scriptFolder, String targetConnectionName, SyncDatabaseInfo syncDatabaseInfo) {
        String sqlCompareFilter;
        this.sb.append(String.format("%n$result = Invoke-DevartSyncDatabaseSchema -Source \"%s\" -Target $%s", scriptFolder, targetConnectionName));
        if (ValidatorUtils.isNotEmpty((String)syncDatabaseInfo.getTransactionIsoLvl())) {
            this.sb.append(String.format(" -TransactionIsolationLevel %s", syncDatabaseInfo.getTransactionIsoLvl()));
        }
        if (ValidatorUtils.isNotEmpty((String)(sqlCompareFilter = syncDatabaseInfo.getSqlCompareFilter()))) {
            String part = String.format(" -FilterPath \"%s\"", sqlCompareFilter);
            this.sb.append(part);
        }
        if (ValidatorUtils.isNotEmpty((String)syncDatabaseInfo.getCompareOptions())) {
            this.sb.append(String.format(" -SynchronizationOptions \"%s\"", syncDatabaseInfo.getCompareOptions()));
        }
        this.addScriptSeparator();
        this.sb.append(String.format("%nif(-Not $result) { [System.Environment]::Exit(1); }", new Object[0]));
    }

    void addNewDatabaseProject(PackageProject project) {
        this.sb.append(String.format("%n$%s = New-DevartDatabaseProject -SourceScriptsFolder \"%s\"", project.getDatabaseProjectName(), project.getSourceFolder()));
        this.addScriptSeparator();
    }

    void addPackageInfo(String databaseProjectName, String id, String packageVersion) {
        this.sb.append(String.format("%nSet-DevartPackageInfo -Project $%s -Id %s", databaseProjectName, id));
        if (ValidatorUtils.isNotEmpty((String)packageVersion)) {
            this.sb.append(String.format(" -Version %s", packageVersion));
        }
        this.addScriptSeparator();
    }

    void addPublishDatabaseProject(String databaseProjectName, String packageVersion, String repository, String api) {
        this.sb.append(String.format("%nPublish-DevartDatabaseProject -Project $%s -Repository %s", databaseProjectName, repository));
        if (ValidatorUtils.isNotEmpty((String)api)) {
            this.sb.append(String.format(" -ApiKey %s", api));
        }
        if (ValidatorUtils.isEmpty((String)packageVersion)) {
            this.sb.append(" -AutoIncrementVersion");
        }
        this.addScriptSeparator();
    }

    void addExecuteScript(boolean isLocalDbServer, Path scriptPath) {
        if (isLocalDbServer) {
            String fileName = scriptPath.getFileName().toString();
            String fileNameWithoutExtenstion = Utils.removeFilenameExtension(fileName);
            String resultVariable = String.format("execute_%s", fileNameWithoutExtenstion);
            this.sb.append(String.format("%n$%s = Invoke-DevartExecuteScript -Connection \"Data Source=(LocalDb)\\%s;Integrated Security=True\" -Input \"%s\";", resultVariable, "DbForgeDevopsLocalDb", scriptPath));
            this.sb.append(String.format("%nif(-Not $%s) { [System.Environment]::Exit(1); };", resultVariable));
        }
    }

    public String toString() {
        return String.format(scriptTemplate, this.sb.toString());
    }

    public String toSecureString() {
        String command = this.sb.toString();
        command = passwordTemplatePattern.matcher(command).replaceAll("${prefix}*****");
        return String.format(scriptTemplate, command);
    }

    private void addScriptSeparator() {
        this.sb.append(separator);
    }
}

