/*
 * Decompiled with CFR 0.152.
 */
package com.devart.dbforge.core;

import com.devart.dbforge.core.Parameters;
import com.devart.dbforge.core.ParametersBuilder;
import com.devart.dbforge.core.StepIds;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepInfo {
    private static final Logger logger = LoggerFactory.getLogger(StepInfo.class);
    StepIds stepId;
    Parameters parameters;

    public StepInfo(StepIds stepId, Map<String, String> runnerParams, File workingDirectory) {
        this.stepId = stepId;
        this.Initialize(runnerParams, workingDirectory);
    }

    void Initialize(Map<String, String> runnerParams, File workingDirectory) {
        switch (this.stepId) {
            case Build: {
                this.parameters = ParametersBuilder.fillBuildStepParams(runnerParams, workingDirectory);
                break;
            }
            case Execute: {
                this.parameters = ParametersBuilder.fillExecuteStepParams(runnerParams, workingDirectory);
                break;
            }
            case Test: {
                this.parameters = ParametersBuilder.fillTestStepParams(runnerParams, workingDirectory);
                break;
            }
            case Sync: {
                this.parameters = ParametersBuilder.fillSyncStepParams(runnerParams, workingDirectory);
                break;
            }
            default: {
                String message = "Step = " + this.stepId + " not handled in switch";
                logger.error(message);
                throw new IllegalArgumentException(message);
            }
        }
    }
}

