/*
 * Decompiled with CFR 0.152.
 */
package com.devart.dbforge.core;

import com.devart.dbforge.core.BaseLogger;
import com.devart.dbforge.core.BuildStep;
import com.devart.dbforge.core.EnvironmentValidator;
import com.devart.dbforge.core.ExecuteStep;
import com.devart.dbforge.core.IStep;
import com.devart.dbforge.core.ParametersBuilder;
import com.devart.dbforge.core.StepIds;
import com.devart.dbforge.core.StepInfo;
import com.devart.dbforge.core.SyncStep;
import com.devart.dbforge.core.TestStep;
import com.devart.dbforge.core.ValidationError;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepManager {
    private static final Logger log = LoggerFactory.getLogger(StepManager.class);

    private StepManager() {
    }

    public static List<ValidationError> validateFrontendFields(StepIds stepId, Map<String, String> runnerParams, File workingDirectory) {
        switch (stepId) {
            case Build: {
                return BuildStep.validateFrontendFields(ParametersBuilder.fillBuildStepParams(runnerParams, workingDirectory));
            }
            case Execute: {
                return ExecuteStep.validateFrontendFields(ParametersBuilder.fillExecuteStepParams(runnerParams, workingDirectory));
            }
            case Test: {
                return TestStep.validateFrontendFields(ParametersBuilder.fillTestStepParams(runnerParams, workingDirectory));
            }
            case Sync: {
                return SyncStep.validateFrontendFields(ParametersBuilder.fillSyncStepParams(runnerParams, workingDirectory));
            }
        }
        String message = "Step = " + stepId + " not handled in switch";
        log.error(message);
        throw new IllegalArgumentException(message);
    }

    public static boolean validateEnvironment(Path workspace, List<StepInfo> steps, BaseLogger logger) {
        EnvironmentValidator environmentValidator = new EnvironmentValidator(logger);
        return environmentValidator.validate(workspace, steps);
    }

    public static IStep createStep(StepIds stepId, Map<String, String> runnerParams, File workingDirectory, BaseLogger logger) {
        switch (stepId) {
            case Build: {
                return new BuildStep(ParametersBuilder.fillBuildStepParams(runnerParams, workingDirectory), logger);
            }
            case Execute: {
                return new ExecuteStep(ParametersBuilder.fillExecuteStepParams(runnerParams, workingDirectory), logger);
            }
            case Test: {
                return new TestStep(ParametersBuilder.fillTestStepParams(runnerParams, workingDirectory), logger);
            }
            case Sync: {
                return new SyncStep(ParametersBuilder.fillSyncStepParams(runnerParams, workingDirectory), logger);
            }
        }
        String message = "Step = " + stepId + " not handled in switch";
        log.error(message);
        throw new IllegalArgumentException(message);
    }
}

