/*
 * Decompiled with CFR 0.152.
 */
package com.devart.dbforge.core;

import com.devart.dbforge.core.BaseLogger;
import com.devart.dbforge.core.ValidatorUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;

class Utils {
    Utils() {
    }

    static Path copyResourceToWorkspace(Path basePath, String relativePath, BaseLogger logger) throws IOException {
        Path fullPath = basePath.resolve(relativePath);
        try {
            URL url = Utils.getUrlFromPath(relativePath, logger);
            Path parent = Files.createDirectories(fullPath.getParent(), new FileAttribute[0]);
            logger.message("Parent dir of target file = " + parent);
            Files.copy(Objects.requireNonNull(url).openStream(), fullPath, StandardCopyOption.REPLACE_EXISTING);
            logger.message("Target file = " + fullPath);
        }
        catch (IOException ex) {
            logger.error("File not copied! Working directory = " + basePath + ", sub path relative to the working directory = " + relativePath);
            throw ex;
        }
        return fullPath;
    }

    static URL getUrlFromPath(String relativePath, BaseLogger logger) {
        URL url;
        ClassLoader loader = ValidatorUtils.class.getClassLoader();
        if (loader == null) {
            logger.error("class loader is null. File " + relativePath + " not copied!");
        }
        if ((url = Objects.requireNonNull(loader).getResource(relativePath)) == null) {
            logger.error("the resource with specified path => " + relativePath + " does not exist");
        }
        return Objects.requireNonNull(url);
    }

    static Optional<Path> generateScriptFile(Path workspace, String script, String extension, BaseLogger logger) {
        try {
            logger.debug("Creating temp file");
            File file = File.createTempFile("PowerShell\\dbforge_devops_script_", extension, workspace.toFile());
            logger.debug("Temp file " + file + " successfully created");
            try (PrintWriter out = new PrintWriter(file, "UTF-8");){
                out.println(script);
            }
            logger.debug("Script writing into file " + file + " successfully");
            return Optional.of(file.toPath());
        }
        catch (IOException e) {
            logger.error("Failed to create a temporary script file: " + e.getMessage());
            return Optional.empty();
        }
    }

    static String removeFilenameExtension(String filename) {
        if (filename == null) {
            return null;
        }
        Utils.failIfNullBytePresent(filename);
        int index = Utils.indexOfExtension(filename);
        return index == -1 ? filename : filename.substring(0, index);
    }

    private static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = Utils.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    private static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    private static void failIfNullBytePresent(String path) {
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            if (path.charAt(i) != '\u0000') continue;
            throw new IllegalArgumentException("Null byte present in file/path name. There are no known legitimate use cases for such data, but several injection attacks may use it");
        }
    }
}

