/*
 * Decompiled with CFR 0.152.
 */
package com.devart.dbforge.core;

import com.devart.dbforge.core.Config;
import com.devart.dbforge.core.ErrorType;
import com.devart.dbforge.core.Parameters;
import com.devart.dbforge.core.ValidationError;
import com.devart.dbforge.core.ValidatorUtils;
import java.util.ArrayList;
import java.util.List;

public final class ExecuteStepParamsValidator {
    public List<ValidationError> checkFrontend(Parameters parameters) {
        List<ValidationError> errors = this.doCheckFilesToExecute(parameters.filesToExecute);
        if (parameters.serverType.equals("server")) {
            errors.addAll(this.doCheckServer(parameters.server));
            errors.addAll(this.doCheckDatabase(parameters.database));
            if (parameters.authenticationType.equals("serverAuthentication")) {
                errors.addAll(this.doCheckUserName(parameters.userName));
            }
        }
        return errors;
    }

    public List<ValidationError> checkBackend(Parameters parameters) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        return errors;
    }

    private List<ValidationError> doCheckServer(String value) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (ValidatorUtils.isEmpty(value)) {
            ValidationError error = new ValidationError("EXECUTE_STEP_PREFIX_server");
            error.errorType = ErrorType.error;
            error.message = Config.getProperty((String)"BuildStepBuilder.DescriptorImpl.errors.missingServer");
            errors.add(error);
        }
        return errors;
    }

    private List<ValidationError> doCheckDatabase(String value) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (ValidatorUtils.isEmpty(value)) {
            ValidationError error = new ValidationError("EXECUTE_STEP_PREFIX_database");
            error.errorType = ErrorType.error;
            error.message = Config.getProperty((String)"BuildStepBuilder.DescriptorImpl.errors.missingDatabase");
            errors.add(error);
        }
        return errors;
    }

    private List<ValidationError> doCheckUserName(String value) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (ValidatorUtils.isEmpty(value)) {
            ValidationError error = new ValidationError("EXECUTE_STEP_PREFIX_userName");
            error.errorType = ErrorType.error;
            error.message = Config.getProperty((String)"BuildStepBuilder.DescriptorImpl.errors.missingUserName");
            errors.add(error);
        }
        return errors;
    }

    private List<ValidationError> doCheckFilesToExecute(String filesToExecute) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (ValidatorUtils.isEmpty(filesToExecute) || !ValidatorUtils.isValidPath(filesToExecute)) {
            ValidationError error = new ValidationError("EXECUTE_STEP_PREFIX_filesToExecute");
            error.errorType = ErrorType.error;
            error.message = Config.getProperty((String)"ExecuteStepParamsValidator.DescriptorImpl.errors.wrongPath");
            errors.add(error);
        }
        return errors;
    }
}

