/*
 * Decompiled with CFR 0.152.
 */
package com.devart.dbforge.core;

import com.devart.dbforge.core.Config;
import com.devart.dbforge.core.ErrorType;
import com.devart.dbforge.core.Parameters;
import com.devart.dbforge.core.ValidationError;
import com.devart.dbforge.core.ValidatorUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public final class TestStepParamsValidator {
    public List<ValidationError> checkFrontend(Parameters parameters) {
        List<ValidationError> errors = this.doCheckPackageIdTemplate(parameters.packageId);
        if (parameters.serverType.equals("server")) {
            errors.addAll(this.doCheckServer(parameters.server));
            errors.addAll(this.doCheckDatabase(parameters.database));
            if (parameters.authenticationType.equals("serverAuthentication")) {
                errors.addAll(this.doCheckUserName(parameters.userName));
            }
        }
        if (parameters.generateTestData) {
            errors.addAll(this.doCheckDgenFileFrontend(parameters.dgenFile));
        }
        if (parameters.runTestMode.equals("runOnly")) {
            errors.addAll(this.doCheckRunTests(parameters.runTests));
        }
        return errors;
    }

    public List<ValidationError> checkBackend(Parameters parameters) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        errors.addAll(this.doCheckPackageId(parameters.packageId));
        if (parameters.generateTestData) {
            errors.addAll(this.doCheckDgenFileBackend(parameters.workspace, parameters.dgenFile));
        }
        return errors;
    }

    private List<ValidationError> doCheckPackageId(String value) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (ValidatorUtils.isEmpty(value)) {
            ValidationError error = new ValidationError("TEST_STEP_PREFIX_packageId");
            error.errorType = ErrorType.error;
            error.message = Config.getProperty((String)"BuildStepBuilder.DescriptorImpl.errors.missingPackageId");
            errors.add(error);
            return errors;
        }
        if (!ValidatorUtils.isValidPackageId(value)) {
            ValidationError error = new ValidationError("TEST_STEP_PREFIX_packageId");
            error.errorType = ErrorType.warning;
            error.message = Config.getProperty((String)"invalidPackageId");
            errors.add(error);
            return errors;
        }
        return errors;
    }

    private List<ValidationError> doCheckPackageIdTemplate(String value) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (ValidatorUtils.isEmpty(value)) {
            ValidationError error = new ValidationError("TEST_STEP_PREFIX_packageId");
            error.errorType = ErrorType.error;
            error.message = Config.getProperty((String)"BuildStepBuilder.DescriptorImpl.errors.missingPackageId");
            errors.add(error);
            return errors;
        }
        if (!ValidatorUtils.isValidPackageIdTemplate(value)) {
            ValidationError error = new ValidationError("TEST_STEP_PREFIX_packageId");
            error.errorType = ErrorType.warning;
            error.message = Config.getProperty((String)"invalidPackageId");
            errors.add(error);
            return errors;
        }
        return errors;
    }

    private List<ValidationError> doCheckServer(String value) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (ValidatorUtils.isEmpty(value)) {
            ValidationError error = new ValidationError("TEST_STEP_PREFIX_server");
            error.errorType = ErrorType.error;
            error.message = Config.getProperty((String)"BuildStepBuilder.DescriptorImpl.errors.missingServer");
            errors.add(error);
            return errors;
        }
        return errors;
    }

    private List<ValidationError> doCheckDatabase(String value) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (ValidatorUtils.isEmpty(value)) {
            ValidationError error = new ValidationError("TEST_STEP_PREFIX_database");
            error.errorType = ErrorType.error;
            error.message = Config.getProperty((String)"BuildStepBuilder.DescriptorImpl.errors.missingDatabase");
            errors.add(error);
            return errors;
        }
        return errors;
    }

    private List<ValidationError> doCheckUserName(String value) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (ValidatorUtils.isEmpty(value)) {
            ValidationError error = new ValidationError("TEST_STEP_PREFIX_userName");
            error.errorType = ErrorType.error;
            error.message = Config.getProperty((String)"BuildStepBuilder.DescriptorImpl.errors.missingUserName");
            errors.add(error);
            return errors;
        }
        return errors;
    }

    private List<ValidationError> doCheckRunTests(String value) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (ValidatorUtils.isEmpty(value)) {
            ValidationError error = new ValidationError("TEST_STEP_PREFIX_runTests");
            error.errorType = ErrorType.error;
            error.message = Config.getProperty((String)"BuildStepBuilder.DescriptorImpl.errors.missingRunTests");
            errors.add(error);
            return errors;
        }
        return errors;
    }

    private List<ValidationError> doCheckDgenFileFrontend(String value) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (ValidatorUtils.isEmpty(value)) {
            ValidationError error = new ValidationError("TEST_STEP_PREFIX_dgenFile");
            error.errorType = ErrorType.error;
            error.message = Config.getProperty((String)"TestStepBuilder.DescriptorImpl.errors.missingDgenPath");
            errors.add(error);
            return errors;
        }
        if (!ValidatorUtils.isValidPath(value) || Paths.get(value, new String[0]).isAbsolute()) {
            ValidationError error = new ValidationError("TEST_STEP_PREFIX_dgenFile");
            error.errorType = ErrorType.error;
            error.message = Config.getProperty((String)"BuildStepBuilder.DescriptorImpl.errors.wrongRelativePath");
            errors.add(error);
            return errors;
        }
        return errors;
    }

    private List<ValidationError> doCheckDgenFileBackend(Path workspace, String value) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (!ValidatorUtils.isFileExist(workspace, value)) {
            ValidationError error = new ValidationError("TEST_STEP_PREFIX_dgenFile");
            error.errorType = ErrorType.error;
            error.message = Config.getProperty((String)"TestStepBuilder.DescriptorImpl.errors.wrongDgenPath");
            errors.add(error);
            return errors;
        }
        return errors;
    }
}

