/*
 * Decompiled with CFR 0.152.
 */
package com.devart.dbforge.core;

import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;

class ValidatorUtils {
    private static String[] invalidChars = new String[]{" ", "-", "~", "<", "!", "@", "/", "$", "%", "^", "&", "#", "\u2116", "(", ")", "?", ">", ",", "*", "|", "'"};
    private static final String validCharacters = "[^\\s\\-~<!@/$%^&#\u2116()?>,*|']";
    private static final String packageId = "[^\\s\\-~<!@/$%^&#\u2116()?>,*|']{1,100}";
    private static final String templateVariable = "%[^%=]+%";
    private static final Pattern packageIdPattern = Pattern.compile("^[^\\s\\-~<!@/$%^&#\u2116()?>,*|']{1,100}$");
    private static final Pattern packageIdTemplatePattern = Pattern.compile("^([^\\s\\-~<!@/$%^&#\u2116()?>,*|']+|%[^%=]+%)+$");

    ValidatorUtils() {
    }

    public static boolean isValidPath(String path) {
        boolean isValid;
        try {
            Paths.get(path, new String[0]);
            isValid = true;
        }
        catch (NullPointerException | InvalidPathException ex) {
            isValid = false;
        }
        return isValid;
    }

    public static boolean isFileExist(Path baseDir, String relativePath) {
        boolean exist;
        try {
            Path fullPath = Paths.get(baseDir.toString(), relativePath);
            exist = Files.exists(fullPath, new LinkOption[0]);
        }
        catch (NullPointerException | InvalidPathException ex) {
            exist = false;
        }
        return exist;
    }

    public static boolean isValidPackageId(String packageId) {
        return packageIdPattern.matcher(packageId).matches();
    }

    public static boolean isValidPackageIdTemplate(String packageIdTemplate) {
        return packageIdTemplatePattern.matcher(packageIdTemplate).matches();
    }

    public static boolean isNotEmpty(String value) {
        return !ValidatorUtils.isEmpty(value);
    }

    public static boolean isEmpty(String value) {
        return value == null || value.chars().allMatch(Character::isWhitespace);
    }
}

