/*
 * Decompiled with CFR 0.152.
 */
package com.devart.dbforge.core;

import java.util.UUID;

class ConnectionInfo {
    static final String localDbInstance = "DbForgeDevopsLocalDb";
    private static final String connectionName = "devartConnection";
    private final String server;
    private final String database;
    private final String userName;
    private final String password;
    private final boolean isLocalDb;
    private final boolean isWindowsAuthentication;

    String print() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nlocalDbInstance =>").append(localDbInstance).append("<=\n").append("connectionName =>").append(connectionName).append("<=\n").append("server =>").append(this.server).append("<=\n").append("database =>").append(this.database).append("<=\n").append("userName =>").append(this.userName).append("<=\n").append("password =>*****<=\n").append("isLocalDb =>").append(this.isLocalDb).append("<=\n").append("isWindowsAuthentication =>").append(this.isWindowsAuthentication).append("<=\n");
        return sb.toString();
    }

    ConnectionInfo(boolean isLocalDb, String server, String database, boolean isWindowsAuthentication, String userName, String password) {
        this.isLocalDb = isLocalDb;
        if (isLocalDb) {
            this.server = String.format("(LocalDb)\\%s", localDbInstance);
            this.database = String.format("dbForgeDevopsTempDb_%s", UUID.randomUUID());
            this.isWindowsAuthentication = true;
            this.userName = null;
            this.password = null;
        } else {
            this.server = server;
            this.database = database;
            this.isWindowsAuthentication = isWindowsAuthentication;
            this.userName = userName;
            this.password = password;
        }
    }

    String getConnectionName() {
        return connectionName;
    }

    boolean isLocalDb() {
        return this.isLocalDb;
    }

    String getServer() {
        return this.server;
    }

    String getDatabase() {
        return this.database;
    }

    boolean getIsWindowsAuthentication() {
        return this.isWindowsAuthentication;
    }

    String getUserName() {
        return this.userName;
    }

    String getPassword() {
        return this.password;
    }
}

