/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.teamcity;

import com.devart.dbforge.core.StepIds;
import com.devart.dbforge.core.StepManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jetbrains.buildServer.serverSide.InvalidProperty;
import jetbrains.buildServer.serverSide.PropertiesProcessor;
import jetbrains.buildServer.serverSide.RunType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRunner
extends RunType {
    private final StepIds stepId;

    public BaseRunner(StepIds stepId) {
        this.stepId = stepId;
    }

    @NotNull
    public String getType() {
        return this.stepId.toString();
    }

    @Nullable
    public PropertiesProcessor getRunnerPropertiesProcessor() {
        return properties -> {
            List errors = StepManager.validateFrontendFields((StepIds)this.stepId, (Map)properties, null);
            return errors.stream().map(error -> new InvalidProperty(error.getKey(), error.getMessage())).collect(Collectors.toList());
        };
    }

    @Nullable
    public Map<String, String> getDefaultRunnerProperties() {
        return new HashMap<String, String>();
    }

    protected String describeParameters(@NotNull Map<String, String> parameters, String stepConstantsPrefix, String[] secureFields) {
        StringBuilder sb = new StringBuilder();
        parameters.forEach((key, value) -> {
            if (Arrays.stream(secureFields).anyMatch(key::equals)) {
                value = "*****";
            }
            sb.append(key.replaceFirst(stepConstantsPrefix, "")).append("=").append((String)value).append("\n");
        });
        return sb.toString();
    }
}

