<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="props" tagdir="/WEB-INF/tags/props" %>
<%@ taglib prefix="l" tagdir="/WEB-INF/tags/layout" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="bs" tagdir="/WEB-INF/tags" %>
<jsp:useBean id="propertiesBean" scope="request" type="jetbrains.buildServer.controllers.BasePropertiesBean"/>
<jsp:useBean id="cons" class="com.devart.dbforge.core.ExecuteStepConstants"/>
<jsp:useBean id="encodingList" class="com.devart.dbforge.core.EncodingList"/>

<c:set var="FilesToExecuteSection" value="Files to execute"/>
<c:set var="Path" value="Path:"/>
<c:set var="PathNoteLine1" value="Specifies a path to a SQL or ZIP file with the script to execute or a folder with SQL or ZIP files."/>
<c:set var="PathNoteLine2" value="If a path refers to a folder, the scripts are executed in alphabetical order (subfolders are ignored)"/>
<c:set var="TargetSection" value="Target database to execute"/>
<c:set var="Server" value="Server:"/>
<c:set var="ServerNote" value="Enter the name of the target server, e.g., SERVERNAME\INSTANCENAME"/>
<c:set var="Database" value="Database:"/>
<c:set var="DatabaseNote" value="Enter the name of the target database"/>
<c:set var="WindowsAuthentication" value="Windows authentication"/>
<c:set var="ServerAuthentication" value="SQL Server authentication"/>
<c:set var="UserName" value="User Name:"/>
<c:set var="UserNameNote" value="Enter the login name for SQL Server authentication"/>
<c:set var="Password" value="Password:"/>
<c:set var="PasswordNote" value="Enter a password for SQL Server authentication"/>
<c:set var="AdvancedSection" value="Advanced Options"/>
<c:set var="Encoding" value="Encoding:"/>
<c:set var="EncodingNote" value="Specifies the encoding to be used to open and execute the script"/>
<c:set var="ZipPassword" value="Zip Password:"/>
<c:set var="ZipPasswordNote" value="Enter a password to the protected archive file"/>
<c:set var="IgnoreError" value="Ignore Error"/>
<c:set var="IgnoreErrorNote" value="Allows scripts execution to continue despite errors"/>

<link rel="stylesheet" type="text/css" href="${teamcityPluginResourcesPath}common.css" />
<%@ include file="Styles.jspf" %>
<%@ include file="Header.jspf" %>

<script type="text/javascript">
    (function () {
        BS.ShowHide = {

            showFields: function (sometimesHiddenItems) {
                sometimesHiddenItems.forEach(function (element) {
                    console.log(element);
                    $(element).show();
                });
            },

            hideFields: function (sometimesHiddenItems) {
                sometimesHiddenItems.forEach(function (element) {
                    console.log(element);
                    $(element).hide();
                });
            }
        };
    })();
</script>

<l:settingsGroup title="${FilesToExecuteSection}">
    <tr id="Path">
        <th><label for="${cons.filesToExecute}">${Path}<l:star/></label></th>
        <td>
            <props:textProperty name="${cons.filesToExecute}" className="longField" maxlength="256"/>
            <span class="smallNote">${PathNoteLine1}</span>
            <span class="smallNote">${PathNoteLine2}</span>
            <span class="error" id="error_${cons.filesToExecute}"></span>
        </td>
    </tr>
</l:settingsGroup>

<l:settingsGroup title="${TargetSection}">
    <tr id="Server">
        <th><label for="${cons.server}">${Server}<l:star/></label></th>
        <td>
            <props:textProperty name="${cons.server}" className="longField" maxlength="256"/>
            <span class="smallNote">${ServerNote}</span>
            <span class="error" id="error_${cons.server}"></span>
        </td>
    </tr>

    <tr id="Database">
        <th><label for="${cons.database}">${Database}<l:star/></label></th>
        <td>
            <props:textProperty name="${cons.database}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="smallNote">${DatabaseNote}</span>
            <span class="error" id="error_${cons.database}"></span>
        </td>
    </tr>

    <c:set var="showAuthenticationSettings"
           value="${propertiesBean.properties[cons.authenticationType].equals('serverAuthentication')}"/>

    <tr>
        <td colspan="2">
            <props:radioButtonProperty
                    name="${cons.authenticationType}"
                    value="windowsAuthentication"
                    onclick="BS.ShowHide.hideFields(['UserName', 'Password'])"
                    checked="true"
            />
            <label for="${cons.authenticationType}">${WindowsAuthentication}</label>
            <br/>
            <props:radioButtonProperty
                    name="${cons.authenticationType}"
                    value="serverAuthentication"
                    onclick="BS.ShowHide.showFields(['UserName', 'Password'])"
            />
            <label for="${cons.authenticationType}">${ServerAuthentication}</label>
            <br/>
        </td>
    </tr>

    <tr id="UserName" style="${showAuthenticationSettings ? '' : 'display: none;'}">
        <th><label for="${cons.userName}">${UserName}<l:star/></label></th>
        <td>
            <props:textProperty name="${cons.userName}" className="longField" maxlength="256"/>
            <span class="smallNote">${UserNameNote}</span>
            <span class="error" id="error_${cons.userName}"></span>
        </td>
    </tr>

    <tr id="Password" style="${showAuthenticationSettings ? '' : 'display: none;'}">

        <th><label for="${cons.password}">${Password}</label></th>
        <td>
            <props:passwordProperty name="${cons.password}" className="longField" maxlength="256"/>
            <span class="smallNote">${PasswordNote}</span>
            <span class="error" id="error_${cons.password}"></span>
        </td>
    </tr>
</l:settingsGroup>

<l:settingsGroup title="${AdvancedSection}" className="advancedSetting">
    <tr id="Encoding" class="advancedSetting">
        <th><label for="${cons.fileEncoding}">${Encoding}</label></th>
        <td>
            <props:selectProperty name="${cons.fileEncoding}" enableFilter="true">
                <c:forEach var="item" items="${encodingList.encodingListItems}">
                    <props:option value="${item.name}"><c:out value="${item.displayName}"/></props:option>
                </c:forEach>
            </props:selectProperty>
            <span class="smallNote">${EncodingNote}</span>
            <span class="error" id="error_${cons.fileEncoding}"></span>
        </td>
    </tr>

    <tr id="ZipPassword" class="advancedSetting">
        <th><label for="${cons.zipPassword}">${ZipPassword}</label></th>
        <td>
            <props:passwordProperty name="${cons.zipPassword}" className="longField" maxlength="256"/>
            <span class="smallNote">${ZipPasswordNote}</span>
            <span class="error" id="error_${cons.zipPassword}"></span>
        </td>
    </tr>

    <tr id="IgnoreError" class="advancedSetting">
        <td colspan="2">
            <props:checkboxProperty name="${cons.ignoreError}"/>
            <label for="${cons.ignoreError}">${IgnoreError}</label>
            <span class="smallNote">${IgnoreErrorNote}</span>
            <span class="error" id="error_${cons.ignoreError}"></span>
        </td>
    </tr>
</l:settingsGroup>
