<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="props" tagdir="/WEB-INF/tags/props" %>
<%@ taglib prefix="l" tagdir="/WEB-INF/tags/layout" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="bs" tagdir="/WEB-INF/tags" %>
<jsp:useBean id="propertiesBean" scope="request" type="jetbrains.buildServer.controllers.BasePropertiesBean"/>
<jsp:useBean id="cons" class="com.devart.dbforge.core.TestStepConstants"/>
<jsp:useBean id="serverTypes" class="com.devart.dbforge.core.ServerTypes"/>
<jsp:useBean id="runTestModes" class="com.devart.dbforge.core.RunTestModes"/>

<c:set var="DatabasePackageSection" value="Database package to test"/>
<c:set var="DatabasePackageSectionDesc"
       value="Enter the ID of the package that you want to test. The ID must be for a package built by dbForge DevOps Automation for SQL Server."/>
<c:set var="PackageId" value="Package ID:"/>
<c:set var="DatabaseServerSection" value="Temporary database server"/>

<c:set var="DatabaseServerSectionDescr"
       value="dbForge DevOps Automation for SQL Server will recreate and validate your database on a temporary server before testing it."/>
<c:set var="LocalDb" value="SQL LocalDB (recommended)"/>
<c:set var="SqlServer" value="SQL Server"/>

<c:set var="Server" value="Server:"/>
<c:set var="Database" value="Temporary database:"/>
<c:set var="WindowsAuthentication" value="Windows authentication"/>

<c:set var="ServerAuthentication" value="SQL Server authentication"/>
<c:set var="UserName" value="User Name:"/>
<c:set var="Password" value="Password:"/>

<c:set var="RunTestsSection" value="Run tests"/>
<c:set var="RunEveryTest" value="Run every test"/>

<c:set var="RunOnly" value="Run selected tests only"/>

<c:set var="TestToBeRun" value="Tests to be run:"/>

<c:set var="GenerateTestDataSection" value="Generate test data"/>

<c:set var="GenerateTestData" value="Populate the database with data before testing"/>
<c:set var="GenerateTestDataFile" value="dbForge Data Generator project file:"/>
<c:set var="GenerateTestDataFileDesc"
       value="Optional. If you already have a dbForge Data Generator project file (.dgen) you wish you use, include the path and filename here. The path must be relative to the VCS root."/>
<c:set var="AdvancedSection" value="Advanced Options"/>
<c:set var="CompareOptions" value="Schema Compare options:"/>
<c:set var="SqlCompareFilter" value="Schema Compare filter:"/>

<link rel="stylesheet" type="text/css" href="${teamcityPluginResourcesPath}common.css" />
<%@ include file="Styles.jspf" %>
<%@ include file="Header.jspf" %>

<script type="text/javascript">
    (function () {
        BS.ShowHide = {
            showFields: function (sometimesHiddenItems) {
                sometimesHiddenItems.forEach(function (element) {
                    $(element).show();
                });
            },

            showSqlServerSettingsFields: function () {
                var radios = document.getElementsByClassName('${cons.authenticationType}');
                for (var i = 0, length = radios.length; i < length; i++) {
                    if (radios[i].checked) {
                        if (radios[i].value == "serverAuthentication") {
                            BS.ShowHide.showFields(['Server', 'Database', 'authenticationType', 'UserName', 'Password']);
                        } else {
                            BS.ShowHide.showFields(['Server', 'Database', 'authenticationType']);
                        }
                        break;
                    }
                }
            },

            hideFields: function (sometimesHiddenItems) {
                sometimesHiddenItems.forEach(function (element) {
                    $(element).hide();
                });
            }
        };
    })();
</script>

<script type="text/javascript">

</script>

<l:settingsGroup title="${DatabasePackageSection}">
    <tr>
        <td colspan="2">
            <div>${DatabasePackageSectionDesc}</div>
        </td>
    </tr>
    <tr>
        <th><label for="${cons.packageId}">${PackageId}<l:star/></label></th>
        <td>
            <props:textProperty name="${cons.packageId}" className="longField" maxlength="100"/>
            <span class="smallNote"></span>
            <span class="note">Specify a unique package name that will also be used in other build steps.</span>
            <span class="error" id="error_${cons.packageId}"></span>
        </td>
    </tr>
</l:settingsGroup>


<l:settingsGroup title="${DatabaseServerSection}">
    <tr>
        <td colspan="2">
            <div>${DatabaseServerSectionDescr}</div>
        </td>
    </tr>

    <c:set var="showServerSettings"
           value="${empty propertiesBean.properties[cons.serverType] ? false
           : propertiesBean.properties[cons.serverType].equals(serverTypes.server)}"/>
    <c:set var="showAuthenticationSettings"
           value="${empty propertiesBean.properties[cons.authenticationType] ? false
           : propertiesBean.properties[cons.authenticationType].equals('serverAuthentication')}"/>

    <tr>
        <td>
            <props:radioButtonProperty
                    name="${cons.serverType}"
                    value="${serverTypes.localDb}"
                    onclick="BS.ShowHide.hideFields(['Server', 'Database', 'authenticationType', 'UserName', 'Password'])"
                    checked="true"


            />
            <label for="${cons.serverType}">${LocalDb}</label>
            <br/>
            <props:radioButtonProperty
                    name="${cons.serverType}"
                    value="${serverTypes.server}"
                    onclick='BS.ShowHide.showSqlServerSettingsFields()'
            />

            <label for="${cons.serverType}">${SqlServer}</label>
            <br/>
        </td>
    </tr>

    <tr id="Server" style="${showServerSettings ? '' : 'display: none;'}">

        <th><label for="${cons.server}">${Server}<l:star/></label></th>
        <td>
            <props:textProperty name="${cons.server}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note"></span>
            <span class="error" id="error_${cons.server}"></span>
        </td>
    </tr>

    <tr id="Database" style="${showServerSettings ? '' : 'display: none;'}">
        <th><label for="${cons.database}">${Database}<l:star/></label></th>
        <td>
            <props:textProperty name="${cons.database}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note"></span>
            <span class="error" id="error_${cons.database}"></span>
        </td>
    </tr>


    <tr id="authenticationType" style="${showServerSettings ? '' : 'display: none;'}">
        <td>
            <props:radioButtonProperty
                    name="${cons.authenticationType}"
                    value="windowsAuthentication"
                    onclick="BS.ShowHide.hideFields(['UserName', 'Password'])"
                    className="${cons.authenticationType}"
                    checked="true"
            />

            <label for="${cons.authenticationType}">${WindowsAuthentication}</label>
            <br/>
            <props:radioButtonProperty
                    name="${cons.authenticationType}"
                    value="serverAuthentication"
                    onclick="BS.ShowHide.showFields(['UserName', 'Password'])"
                    className="${cons.authenticationType}"
            />

            <label for="${cons.authenticationType}">${ServerAuthentication}</label>
            <br/>
        </td>
    </tr>

    <tr id="UserName"
        style="${showServerSettings ? (showAuthenticationSettings ? '' : 'display: none;') : 'display: none;'}">

        <th><label for="${cons.userName}">${UserName}<l:star/></label></th>
        <td>
            <props:textProperty name="${cons.userName}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note"></span>
            <span class="error" id="error_${cons.userName}"></span>
        </td>
    </tr>

    <tr id="Password"
        style="${showServerSettings ? (showAuthenticationSettings ? '' : 'display: none;') : 'display: none;'}">

        <th><label for="${cons.password}">${Password}</label></th>
        <td>
            <props:passwordProperty name="${cons.password}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note"></span>
            <span class="error" id="error_${cons.password}"></span>
        </td>
    </tr>
</l:settingsGroup>


<l:settingsGroup title="${RunTestsSection}">
    <c:set var="showTestToBeRunSettings"
           value="${propertiesBean.properties[cons.runTestMode].equals('runOnly')}"/>

    <tr>
        <td>
            <props:radioButtonProperty
                    name="${cons.runTestMode}"
                    value="${runTestModes.runAll}"
                    onclick="BS.ShowHide.hideFields(['TestToBeRun'])"
                    checked="true"
            />
            <label for="${cons.runTestMode}">${RunEveryTest}</label>
            <br/>
            <props:radioButtonProperty
                    name="${cons.runTestMode}"
                    value="${runTestModes.runOnly}"
                    onclick="BS.ShowHide.showFields(['TestToBeRun'])"
            />
            <label for="${cons.runTestMode}">${RunOnly}</label>
            <br/>
        </td>
    </tr>
    <tr id="TestToBeRun" style="${showTestToBeRunSettings ? '' : 'display: none;'}">
        <th><label for="${cons.runTests}">${TestToBeRun}<l:star/></label></th>
        <td>
            <props:textProperty name="${cons.runTests}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note"></span>
            <span class="error" id="error_${cons.runTests}"></span>
        </td>
    </tr>
</l:settingsGroup>

<l:settingsGroup title="${GenerateTestDataSection}">
    <c:set var="showSettings5"
           value="${empty propertiesBean.properties[cons.generateTestData] ? false : propertiesBean.properties[cons.generateTestData]}"/>

    <tr>
        <th><label for="${cons.generateTestData}">${GenerateTestData}</label></th>
        <td>
            <props:checkboxProperty name="${cons.generateTestData}" uncheckedValue="false" onclick="{
              if (this.checked) {BS.ShowHide.showFields(['GenerateTestDataFile', 'GenerateTestDataFileDesc'])} else {
                BS.ShowHide.hideFields(['GenerateTestDataFile', 'GenerateTestDataFileDesc'])
              }
            }"/>
        </td>
    </tr>


    <tr id="GenerateTestDataFile" style="${showSettings5 ? '' : 'display: none;'}">

        <th><label for="${cons.dgenFile}">${GenerateTestDataFile}<l:star/></label></th>
        <td>
            <props:textProperty name="${cons.dgenFile}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note"></span>
            <span class="error" id="error_${cons.dgenFile}"></span>
        </td>
    </tr>


    <tr id="GenerateTestDataFileDesc" style="${showSettings5 ? '' : 'display: none;'}">
        <td colspan="2">
            <div>${GenerateTestDataFileDesc}</div>
        </td>
    </tr>
</l:settingsGroup>

<l:settingsGroup title="${AdvancedSection}" className="advancedSetting">
    <tr id="CompareOptions" class="advancedSetting">
        <th><label for="${cons.compareOptions}">${CompareOptions}</label></th>
        <td>
            <props:textProperty name="${cons.compareOptions}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note"></span>
            <span class="error" id="error_${cons.compareOptions}"></span>
        </td>
    </tr>
    <tr id="SqlCompareFilter" class="advancedSetting">
        <th><label for="${cons.sqlCompareFilter}">${SqlCompareFilter}</label></th>
        <td>
            <props:textProperty name="${cons.sqlCompareFilter}" className="longField" maxlength="256"/>
            <span class="smallNote"></span>
            <span class="note">Specifies a path to an alternative filter file which will be used for validating the schema to override *.scflt filter file present in the input.</span>
            <span class="error" id="error_${cons.sqlCompareFilter}"></span>
        </td>
    </tr>
</l:settingsGroup>