unit DemoFrame;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Classes,
{$IFDEF MSWINDOWS}
  Windows, Messages,
{$ENDIF}
  Forms, SysUtils, StdCtrls, Graphics, Controls, Dialogs,
  ComCtrls, Buttons, ExtCtrls, DBCtrls,
{$IFDEF FPC}
  LResources,
{$ENDIF}
  {$IFNDEF VER130}Variants,{$ENDIF}
  EntityDAC.Context,
{$IFDEF USE_GENERICS}
  EntityDAC.ObjectContext,
  Demo.ObjectContext,
  Demo.AttributeContext,
{$ENDIF}
  EntityDAC.EntityContext,
  Demo.Context;

type
  TContextType = (ctEntity, ctPlainEntity, ctPlainObject);

  TDemoFrame = class(TFrame)
  private
    FSelector: integer;
    FDemoContext: Demo.Context.TDemoContext;
{$IFDEF USE_GENERICS}
    FEntityContext: Demo.AttributeContext.TDemoContext;
    FObjectContext: Demo.ObjectContext.TDemoContext;
{$ENDIF}
    FContextType: TContextType;

    function GetDemoContext: Demo.Context.TDemoContext;
{$IFDEF USE_GENERICS}
    function GetEntityContext: Demo.AttributeContext.TDemoContext;
    function GetObjectContext: Demo.ObjectContext.TDemoContext;
{$ENDIF}
    function GetUsedContext: TDataContext;
  protected
    function GetUnitFolder: string; virtual;
  public
    constructor Create(AOwner: TComponent); override;

  {$IFNDEF VER12P}
    class function UnitName: string;
  {$ENDIF}

    procedure Initialize; virtual;
    procedure Finalize; virtual;
    procedure SetDebug(Value: boolean); virtual;

    procedure ShowDemoPiece(Button: TButton; Strings: TStrings); overload;
    procedure ShowDemoPiece(Button: TButton; Memo: TMemo); overload;
    procedure ShowDemoPiece(ProcedureName: string; Strings: TStrings); overload;
    procedure ShowDemoPiece(ProcedureName: string; Memo: TMemo); overload;

    function CheckProperty(PatternName, NameToVerify: string): Boolean;

    property Selector: integer read FSelector write FSelector;
    property ContextType: TContextType read FContextType write FContextType default ctEntity;

    property DemoContext: Demo.Context.TDemoContext read GetDemoContext;
{$IFDEF USE_GENERICS}
    property EntityContext: Demo.AttributeContext.TDemoContext read GetEntityContext;
    property ObjectContext: Demo.ObjectContext.TDemoContext read GetObjectContext;
{$ENDIF}
    property UsedContext: TDataContext read GetUsedContext;

    property UnitFolder: string read GetUnitFolder;
  end;

  TDemoFrameClass = class of TDemoFrame;

implementation

uses
  DemoForm,
  Demo.MetaData;

{$R *.dfm}

constructor TDemoFrame.Create(AOwner: TComponent);
begin
  inherited;

  FContextType := ctEntity;
end;

function TDemoFrame.GetDemoContext: Demo.Context.TDemoContext;
begin
  if FDemoContext = nil then begin
    FDemoContext := Demo.Context.TDemoContext.Create(nil);
    FDemoContext.Connection := MainDemoForm.GetConnection;
  end;
  Result := FDemoContext;
end;

{$IFNDEF VER12P}
type
  PClassData = ^TClassData;
  TClassData = record
    ClassType: TClass;
    ParentInfo: Pointer;
    PropCount: SmallInt;
    UnitName: ShortString;
  end;

class function TDemoFrame.UnitName: string;
var
  LClassInfo: Pointer;
begin
  LClassInfo := ClassInfo;
  if LClassInfo <> nil then
    Result := PClassData(Integer(LClassInfo) + 2 + PByte(Integer(LClassInfo) + 1)^).UnitName
  else
    Result := '';
end;
{$ENDIF}

{$IFDEF USE_GENERICS}
function TDemoFrame.GetEntityContext: Demo.AttributeContext.TDemoContext;
begin
  if FEntityContext = nil then begin
    FEntityContext := Demo.AttributeContext.TDemoContext.Create;
    FEntityContext.Connection := MainDemoForm.GetConnection;
  end;
  Result := FEntityContext;
end;

function TDemoFrame.GetObjectContext: Demo.ObjectContext.TDemoContext;
begin
  if FObjectContext = nil then begin
    FObjectContext := Demo.ObjectContext.TDemoContext.Create;
    FObjectContext.Connection := MainDemoForm.GetConnection;
  end;
  Result := FObjectContext;
end;
{$ENDIF}

function TDemoFrame.GetUsedContext: TDataContext;
begin
  Result := nil;
  case FContextType of
    ctEntity: Result := DemoContext;
{$IFDEF USE_GENERICS}
    ctPlainEntity: Result := EntityContext;
    ctPlainObject: Result := ObjectContext;
{$ENDIF}
  end;
end;

function TDemoFrame.GetUnitFolder: string;
begin
  Result := 'Base';
end;

procedure TDemoFrame.Initialize;
begin
end;

procedure TDemoFrame.Finalize;
begin
  FreeAndNil(FDemoContext);
{$IFDEF USE_GENERICS}
  FreeAndNil(FEntityContext);
  FreeAndNil(FObjectContext);
{$ENDIF}  
end;

procedure TDemoFrame.SetDebug(Value: boolean);
begin
end;

function TDemoFrame.CheckProperty(PatternName, NameToVerify: string): Boolean;
begin
  if PatternName = '' then
    raise Exception.Create('PatternName can not be empty');
  Result := (NameToVerify = '') or (UpperCase(PatternName) = UpperCase(NameToVerify));
end;

procedure TDemoFrame.ShowDemoPiece(Button: TButton; Strings: TStrings);
begin
  MainDemoForm.Demos.SelectedDemo.LoadDemoPiece(Button, Strings);
end;

procedure TDemoFrame.ShowDemoPiece(Button: TButton; Memo: TMemo);
begin
  ShowDemoPiece(Button, Memo.Lines);
  Memo.SelStart := 0;
  Memo.SelLength := 0;
end;

procedure TDemoFrame.ShowDemoPiece(ProcedureName: string; Strings: TStrings);
begin
  MainDemoForm.Demos.SelectedDemo.LoadDemoPiece(ProcedureName, Strings);
end;

procedure TDemoFrame.ShowDemoPiece(ProcedureName: string; Memo: TMemo);
begin
  ShowDemoPiece(ProcedureName, Memo.Lines);
  Memo.SelStart := 0;
  Memo.SelLength := 0;
end;

end.
