unit CreateEntityFrameE;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.AttributeClasses,
  DemoFrame, DataContextFrame, CreateEntityFrame;

type
  TCreateEntityFrameE = class(TCreateEntityFrame)
    procedure btCreateEntityClick(Sender: TObject);
    procedure btCreateAttachedEntityClick(Sender: TObject);
    procedure btCreateEntityWithAutoIDClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

uses
  EntityDAC.Linq;

{$R *.dfm}

procedure TCreateEntityFrameE.Initialize;
begin
  inherited;

  EntitiesToGrid(EntityContext.GetEntities(TDept), grdResult);
end;

procedure TCreateEntityFrameE.btCreateAttachedEntityClick(Sender: TObject);
var
  Dept: TDept;
begin
  // Create new entity and attach to DataContext
  // If Identity generator exist, then DeptNo will be filled
  Dept := EntityContext.CreateAttachedEntity(TDept) as TDept;
  // Fill attributes
  Dept.DName := 'New Dept ' + IntToStr(Dept.DeptNo);
  Dept.Loc := 'New LOC';
  // Save
  Dept.Save;

  EntitiesToGrid(EntityContext.GetEntities(TDept), grdResult);

  inherited;
end;

procedure TCreateEntityFrameE.btCreateEntityClick(Sender: TObject);
var
  Dept: TDept;
  Query: ILinqQueryable;
begin
  // Create new entity
  Dept := EntityContext.CreateEntity(TDept) as TDept;
  // Fill DeptNo
  Query := Linq.From(EntityContext['Dept']).OrderByDescending(EntityContext['Dept']['Deptno']).Select.First;
  Dept.DeptNo := (EntityContext.GetEntity(Query) as TDept).DeptNo + 1;
  // Attach entity to DataContext
  Dept.Attach(EntityContext);
  // Fill other attributes
  Dept.DName := 'New Dept ' + IntToStr(Dept.DeptNo);
  Dept.Loc := 'New LOC';
  // Save
  Dept.Save;

  EntitiesToGrid(EntityContext.GetEntities(TDept), grdResult);

  inherited;
end;

procedure TCreateEntityFrameE.btCreateEntityWithAutoIDClick(Sender: TObject);
var
  Dept: TDept;
begin
  // Create new entity
  // If Identity generator exist, then DeptNo will be filled
  Dept := EntityContext.CreateEntity(TDept) as TDept;
  // Other attributes can be filled before attach to DataContext
  Dept.DName := 'New Dept ' + IntToStr(Dept.DeptNo);
  Dept.Loc := 'New LOC';
  // Attach entity to DataContext
  Dept.Attach(EntityContext);
  // Save
  Dept.Save;

  EntitiesToGrid(EntityContext.GetEntities(TDept), grdResult);

  inherited;
end;

end.
