unit CreateEntityFrameG;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, DBCtrls, Forms, Dialogs, DB, Grids, DBGrids,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.Classes,
  Demo.Linq,
  DemoFrame, DataContextFrame, CreateEntityFrame;

type
  TCreateEntityFrameG = class(TCreateEntityFrame)
    procedure btCreateEntityClick(Sender: TObject);
    procedure btCreateAttachedEntityClick(Sender: TObject);
    procedure btCreateEntityWithAutoIDClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

uses
  EntityDAC.Linq;

{$R *.dfm}

procedure TCreateEntityFrameG.Initialize;
begin
  inherited;

  EntitiesToGrid<TDept>(DemoContext.GetEntities<TDept>, grdResult);
end;

procedure TCreateEntityFrameG.btCreateAttachedEntityClick(Sender: TObject);
var
  Dept: TDept;
begin
  // Create new entity and attach to DataContext
  // If Identity generator exist, then DeptNo will be filled
  Dept := DemoContext.CreateAttachedEntity<TDept>;
  // Fill attributes
  Dept.DName := 'New Dept ' + IntToStr(Dept.DeptNo);
  Dept.Loc := 'New LOC';
  // Save
  Dept.Save;

  EntitiesToGrid<TDept>(DemoContext.GetEntities<TDept>, grdResult);

  inherited;
end;

procedure TCreateEntityFrameG.btCreateEntityClick(Sender: TObject);
var
  Dept: TDept;
  Query: ILinqQueryable;
begin
  // Create new entity
  Dept := DemoContext.CreateEntity<TDept>;
  // Fill DeptNo
  Query := Linq.From(DemoContext.Dept).OrderByDescending(DemoContext.Dept.Deptno).Select.First;
  Dept.DeptNo := DemoContext.GetEntity<TDept>(Query).DeptNo + 1;
  // Attach entity to DataContext
  Dept.Attach(DemoContext);
  // Fill other attributes
  Dept.DName := 'New Dept ' + IntToStr(Dept.DeptNo);
  Dept.Loc := 'New LOC';
  // Save
  Dept.Save;

  EntitiesToGrid<TDept>(DemoContext.GetEntities<TDept>, grdResult);

  inherited;
end;

procedure TCreateEntityFrameG.btCreateEntityWithAutoIDClick(Sender: TObject);
var
  Dept: TDept;
begin
  // Create new entity
  // If Identity generator exist, then DeptNo will be filled
  Dept := DemoContext.CreateEntity<TDept>;
  // Attach entity to DataContext
  Dept.Attach(DemoContext);
  // Other attributes can be filled before attach to DataContext
  Dept.DName := 'New Dept ' + IntToStr(Dept.DeptNo);
  Dept.Loc := 'New LOC';
  // Save
  Dept.Save;

  EntitiesToGrid<TDept>(DemoContext.GetEntities<TDept>, grdResult);

  inherited;
end;

end.
