unit CreateEntityFrameO;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.Objects,
  DemoFrame, DataContextFrame, CreateEntityFrame;

type
  TCreateEntityFrameO = class(TCreateEntityFrame)
    procedure btCreateEntityClick(Sender: TObject);
    procedure btCreateAttachedEntityClick(Sender: TObject);
    procedure btCreateEntityWithAutoIDClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

uses
  EntityDAC.Linq;

{$R *.dfm}

procedure TCreateEntityFrameO.Initialize;
begin
  inherited;

  EntitiesToGrid<TDept>(ObjectContext.GetEntities<TDept>, grdResult);
end;

procedure TCreateEntityFrameO.btCreateAttachedEntityClick(Sender: TObject);
var
  Dept: TDept;
begin
  // Create new entity and attach to DataContext
  // If Identity generator exist, then DeptNo will be filled
  Dept := ObjectContext.CreateAttachedEntity<TDept>;
  // Fill attributes
  Dept.DName := 'New Dept ' + IntToStr(Dept.DeptNo);
  Dept.Loc := 'New LOC';
  // Save
  ObjectContext.Save(Dept);

  EntitiesToGrid<TDept>(ObjectContext.GetEntities<TDept>, grdResult);

  inherited;
end;

procedure TCreateEntityFrameO.btCreateEntityClick(Sender: TObject);
var
  Dept: TDept;
  Query: ILinqQueryable;
begin
  // Create new entity
  Dept := ObjectContext.CreateEntity<TDept>;
  // Fill DeptNo
  Query := Linq.From(ObjectContext['Dept']).OrderByDescending(ObjectContext['Dept']['Deptno']).Select.First;
  Dept.DeptNo := ObjectContext.GetEntity<TDept>(Query).Deptno + 1;
  // Attach entity to DataContext
  ObjectContext.Attach(Dept);
  // Fill other attributes
  Dept.DName := 'New Dept ' + IntToStr(Dept.DeptNo);
  Dept.Loc := 'New LOC';
  // Save
  ObjectContext.Save(Dept);

  EntitiesToGrid<TDept>(ObjectContext.GetEntities<TDept>, grdResult);

  inherited;
end;

procedure TCreateEntityFrameO.btCreateEntityWithAutoIDClick(Sender: TObject);
var
  Dept: TDept;
begin
  // Create new entity
  // If Identity generator exist, then DeptNo will be filled
  Dept := ObjectContext.CreateEntity<TDept>;
  // Other attributes can be filled before attach to DataContext
  Dept.DName := 'New Dept ' + IntToStr(Dept.DeptNo);
  Dept.Loc := 'New LOC';
  // Attach entity to DataContext
  ObjectContext.Attach(Dept);
  // Save
  ObjectContext.Save(Dept);

  EntitiesToGrid<TDept>(ObjectContext.GetEntities<TDept>, grdResult);

  inherited;
end;

end.
