unit DataValidationFrameE;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls, Mask,
  EntityDAC.Common.DataSet,
  EntityDAC.Common.VirtualDataSet,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  EntityDAC.EntityDataSet,
  Demo.AttributeClasses,
  Demo.Linq,
  DemoFrame, DataContextFrame, DataValidationFrame;

type
  TDataValidationFrameE = class(TDataValidationFrame)
    DBNavigator1: TDBNavigator;
    procedure btSetLongStringClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}

procedure TDataValidationFrameE.Initialize;
var
  Emps: IEnumerable;
begin
  inherited;

  Emps := EntityContext.GetEntities(TEmp);
  EntityDataSet1.SourceCollection := Emps;
  EntityDataSet1.Open;
end;

procedure TDataValidationFrameE.btSetLongStringClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := EntityDataSet1.CurrentEntity as TEmp;
  Emp.EName := edEName.Text;
  Emp.Save;

  inherited;
end;

end.
