unit DataValidationFrameG;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls, Mask,
  EntityDAC.Common.DataSet,
  EntityDAC.Common.VirtualDataSet,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  EntityDAC.EntityDataSet,
  Demo.Classes,
  Demo.Linq,
  DemoFrame, DataContextFrame, DataValidationFrame;

type
  TDataValidationFrameG = class(TDataValidationFrame)
    DBNavigator1: TDBNavigator;
    procedure btSetLongStringClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}

procedure TDataValidationFrameG.Initialize;
var
  Emps: IEnumerable<TEmp>;
begin
  inherited;

  Emps := DemoContext.GetEntities<TEmp>;
  EntityDataSet1.SourceCollection := Emps;
  EntityDataSet1.Open;
end;

procedure TDataValidationFrameG.btSetLongStringClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := EntityDataSet1.Current<TEmp>;
  Emp.EName := edEName.Text;
  Emp.Save;

  inherited;
end;

end.
