unit DataValidationFrameO;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls, Mask,
  EntityDAC.Common.DataSet,
  EntityDAC.Common.VirtualDataSet,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  EntityDAC.EntityDataSet,
  Demo.Objects,
  Demo.AttributeClasses,
  Demo.Linq,
  DataContextFrame, DataValidationFrame;

type
  TDataValidationFrameO = class(TDataValidationFrame)
    DBNavigator1: TDBNavigator;
    procedure btSetLongStringClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}

procedure TDataValidationFrameO.Initialize;
var
  Emps: IEnumerable<TEmp>;
begin
  inherited;

  Emps := ObjectContext.GetEntities<TEmp>;
  EntityDataSet1.SourceCollection := Emps;
  EntityDataSet1.Open;
end;

procedure TDataValidationFrameO.btSetLongStringClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := EntityDataSet1.Current<TEmp>;
  Emp.EName := edEName.Text;
  ObjectContext.Save(Emp);

  inherited;
end;

end.
