unit DeleteCascadeFrameE;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.AttributeClasses,
  DemoFrame, DataContextFrame, DeleteCascadeFrame;

type
  TDeleteCascadeFrameE = class(TDeleteCascadeFrame)
    btDeleteDept: TButton;
    Memo1: TMemo;
    procedure btDeleteCascadeClick(Sender: TObject);
    procedure btCancelDeleteCascadeClick(Sender: TObject);
    procedure btDeleteAndSaveCascadeClick(Sender: TObject);
    procedure btDeleteDeptClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}

procedure TDeleteCascadeFrameE.Initialize;
begin
  inherited;

  EntitiesToGrid(EntityContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(EntityContext.GetEntities(TEmp), grdDetail);
end;

procedure TDeleteCascadeFrameE.btCancelDeleteCascadeClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := EntityContext.GetEntities(TDept).Last as TDept;

  // Delete Dept cascade from DataContext
  Dept.Delete(True);
  // Cancel Dept deleting cascade
  Dept.Cancel(True);

  EntitiesToGrid(EntityContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(EntityContext.GetEntities(TEmp), grdDetail);

  inherited;
end;

procedure TDeleteCascadeFrameE.btDeleteAndSaveCascadeClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := EntityContext.GetEntities(TDept).Last as TDept;

  // Delete Dept cascade from DataContext and Database
  Dept.DeleteAndSave(True);

  EntitiesToGrid(EntityContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(EntityContext.GetEntities(TEmp), grdDetail);

  inherited;
end;

procedure TDeleteCascadeFrameE.btDeleteCascadeClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := EntityContext.GetEntities(TDept).Last as TDept;

  // Delete Dept cascade from DataContext
  Dept.Delete(True);
  // Delete Dept cascade from Database
  Dept.Save(True);

  EntitiesToGrid(EntityContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(EntityContext.GetEntities(TEmp), grdDetail);

  inherited;
end;

procedure TDeleteCascadeFrameE.btDeleteDeptClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := EntityContext.GetEntities(TDept).Last as TDept;

  Dept.Delete;
  Dept.Save;

  EntitiesToGrid(EntityContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(EntityContext.GetEntities(TEmp), grdDetail);

  inherited;
end;

end.
