unit DeleteCascadeFrameG;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.Classes,
  Demo.Linq,
  DemoFrame, DataContextFrame, DeleteCascadeFrame;

type
  TDeleteCascadeFrameG = class(TDeleteCascadeFrame)
    btDeleteDept: TButton;
    Memo1: TMemo;
    procedure btDeleteCascadeClick(Sender: TObject);
    procedure btCancelDeleteCascadeClick(Sender: TObject);
    procedure btDeleteAndSaveCascadeClick(Sender: TObject);
    procedure btDeleteDeptClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}

procedure TDeleteCascadeFrameG.Initialize;
begin
  inherited;

  EntitiesToGrid<TDept>(DemoContext.GetEntities<TDept>, grdMaster);
  EntitiesToGrid<TEmp>(DemoContext.GetEntities<TEmp>, grdDetail);
end;

procedure TDeleteCascadeFrameG.btCancelDeleteCascadeClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := DemoContext.GetEntities<TDept>.Last;

  // Delete Dept cascade from DataContext
  Dept.Delete(True);
  // Cancel Dept deleting cascade
  Dept.Cancel(True);

  EntitiesToGrid<TDept>(DemoContext.GetEntities<TDept>, grdMaster);
  EntitiesToGrid<TEmp>(DemoContext.GetEntities<TEmp>, grdDetail);

  inherited;
end;

procedure TDeleteCascadeFrameG.btDeleteAndSaveCascadeClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := DemoContext.GetEntities<TDept>.Last;

  // Delete Dept cascade from DataContext and Database
  Dept.DeleteAndSave(True);

  EntitiesToGrid<TDept>(DemoContext.GetEntities<TDept>, grdMaster);
  EntitiesToGrid<TEmp>(DemoContext.GetEntities<TEmp>, grdDetail);

  inherited;
end;

procedure TDeleteCascadeFrameG.btDeleteCascadeClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := DemoContext.GetEntities<TDept>.Last;

  // Delete Dept cascade from DataContext
  Dept.Delete(True);
  // Delete Dept cascade from Database
  Dept.Save(True);

  EntitiesToGrid<TDept>(DemoContext.GetEntities<TDept>, grdMaster);
  EntitiesToGrid<TEmp>(DemoContext.GetEntities<TEmp>, grdDetail);

  inherited;
end;

procedure TDeleteCascadeFrameG.btDeleteDeptClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := DemoContext.GetEntities<TDept>.Last;

  Dept.Delete;
  Dept.Save;

  EntitiesToGrid<TDept>(DemoContext.GetEntities<TDept>, grdMaster);
  EntitiesToGrid<TEmp>(DemoContext.GetEntities<TEmp>, grdDetail);

  inherited;
end;

end.
