unit DeleteCascadeFrameM;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.Classes,
  Demo.Linq,
  DemoFrame, DataContextFrame, DeleteCascadeFrame;

type
  TDeleteCascadeFrameM = class(TDeleteCascadeFrame)
    btDeleteDept: TButton;
    Memo1: TMemo;
    procedure btDeleteCascadeClick(Sender: TObject);
    procedure btCancelDeleteCascadeClick(Sender: TObject);
    procedure btDeleteAndSaveCascadeClick(Sender: TObject);
    procedure btDeleteDeptClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}

procedure TDeleteCascadeFrameM.Initialize;
begin
  inherited;

  EntitiesToGrid(DemoContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(DemoContext.GetEntities(TEmp), grdDetail);
end;

procedure TDeleteCascadeFrameM.btCancelDeleteCascadeClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := DemoContext.GetEntities(TDept).Last as TDept;

  // Delete Dept cascade from DataContext
  Dept.Delete(True);
  // Cancel Dept deleting cascade
  Dept.Cancel(True);

  EntitiesToGrid(DemoContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(DemoContext.GetEntities(TEmp), grdDetail);

  inherited;
end;

procedure TDeleteCascadeFrameM.btDeleteAndSaveCascadeClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := DemoContext.GetEntities(TDept).Last as TDept;

  // Delete Dept cascade from DataContext and Database
  Dept.DeleteAndSave(True);

  EntitiesToGrid(DemoContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(DemoContext.GetEntities(TEmp), grdDetail);

  inherited;
end;

procedure TDeleteCascadeFrameM.btDeleteCascadeClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := DemoContext.GetEntities(TDept).Last as TDept;

  // Delete Dept cascade from DataContext
  Dept.Delete(True);
  // Delete Dept cascade from Database
  Dept.Save(True);

  EntitiesToGrid(DemoContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(DemoContext.GetEntities(TEmp), grdDetail);

  inherited;
end;

procedure TDeleteCascadeFrameM.btDeleteDeptClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := DemoContext.GetEntities(TDept).Last as TDept;

  Dept.Delete;
  Dept.Save;

  EntitiesToGrid(DemoContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(DemoContext.GetEntities(TEmp), grdDetail);

  inherited;
end;

end.
