unit DeleteCascadeFrameO;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.Objects,
  DemoFrame, DataContextFrame, DeleteCascadeFrame;

type
  TDeleteCascadeFrameO = class(TDeleteCascadeFrame)
    btDeleteDept: TButton;
    Memo1: TMemo;
    procedure btDeleteCascadeClick(Sender: TObject);
    procedure btCancelDeleteCascadeClick(Sender: TObject);
    procedure btDeleteAndSaveCascadeClick(Sender: TObject);
    procedure btDeleteDeptClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}

procedure TDeleteCascadeFrameO.Initialize;
begin
  inherited;

  EntitiesToGrid<TDept>(ObjectContext.GetEntities<TDept>, grdMaster);
  EntitiesToGrid<TEmp>(ObjectContext.GetEntities<TEmp>, grdDetail);
end;

procedure TDeleteCascadeFrameO.btCancelDeleteCascadeClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := ObjectContext.GetEntities<TDept>.Last;

  // Delete Dept cascade from DataContext
  ObjectContext.Delete(Dept, True);
  // Cancel Dept deleting cascade
  ObjectContext.Cancel(Dept, True);

  EntitiesToGrid<TDept>(ObjectContext.GetEntities<TDept>, grdMaster);
  EntitiesToGrid<TEmp>(ObjectContext.GetEntities<TEmp>, grdDetail);

  inherited;
end;

procedure TDeleteCascadeFrameO.btDeleteAndSaveCascadeClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := ObjectContext.GetEntities<TDept>.Last;

  // Delete Dept cascade from DataContext and Database
  ObjectContext.DeleteAndSave(Dept, True);

  EntitiesToGrid<TDept>(ObjectContext.GetEntities<TDept>, grdMaster);
  EntitiesToGrid<TEmp>(ObjectContext.GetEntities<TEmp>, grdDetail);

  inherited;
end;

procedure TDeleteCascadeFrameO.btDeleteCascadeClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := ObjectContext.GetEntities<TDept>.Last;

  // Delete Dept cascade from DataContext
  ObjectContext.Delete(Dept, True);
  // Delete Dept cascade from Database
  ObjectContext.Save(Dept, True);

  EntitiesToGrid<TDept>(ObjectContext.GetEntities<TDept>, grdMaster);
  EntitiesToGrid<TEmp>(ObjectContext.GetEntities<TEmp>, grdDetail);

  inherited;
end;

procedure TDeleteCascadeFrameO.btDeleteDeptClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := ObjectContext.GetEntities<TDept>.Last;

  ObjectContext.Delete(Dept);
  ObjectContext.Save(Dept);

  EntitiesToGrid<TDept>(ObjectContext.GetEntities<TDept>, grdMaster);
  EntitiesToGrid<TEmp>(ObjectContext.GetEntities<TEmp>, grdDetail);

  inherited;
end;

end.
