unit DeleteEntityFrameE;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.AttributeClasses,
  DemoFrame, DataContextFrame, DeleteEntityFrame;

type
  TDeleteEntityFrameE = class(TDeleteEntityFrame)
    procedure btDeleteEntityClick(Sender: TObject);
    procedure btCancelDeleteClick(Sender: TObject);
    procedure btDeleteAndSaveClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}

procedure TDeleteEntityFrameE.Initialize;
begin
  inherited;

  EntitiesToGrid(EntityContext.GetEntities(TEmp), grdResult);
end;

procedure TDeleteEntityFrameE.btCancelDeleteClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := EntityContext.GetEntities(TEmp).Last as TEmp;

  // Delete entity from DataContext
  Emp.Delete;
  // Cancel entity deleting
  Emp.Cancel;

  EntitiesToGrid(EntityContext.GetEntities(TEmp), grdResult);

  inherited;
end;

procedure TDeleteEntityFrameE.btDeleteAndSaveClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := EntityContext.GetEntities(TEmp).Last as TEmp;

  // Delete entity from DataContext and Database
  Emp.DeleteAndSave;

  EntitiesToGrid(EntityContext.GetEntities(TEmp), grdResult);

  inherited;
end;

procedure TDeleteEntityFrameE.btDeleteEntityClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := EntityContext.GetEntities(TEmp).Last as TEmp;

  // Delete entity from DataContext
  Emp.Delete;
  // Delete entity from Database
  Emp.Save;

  EntitiesToGrid(EntityContext.GetEntities(TEmp), grdResult);

  inherited;
end;


end.