unit DeleteEntityFrameG;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.Classes,
  Demo.Linq,
  DemoFrame, DataContextFrame, DeleteEntityFrame;

type
  TDeleteEntityFrameG = class(TDeleteEntityFrame)
    procedure btDeleteEntityClick(Sender: TObject);
    procedure btCancelDeleteClick(Sender: TObject);
    procedure btDeleteAndSaveClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}

procedure TDeleteEntityFrameG.Initialize;
begin
  inherited;

  EntitiesToGrid<TEmp>(DemoContext.GetEntities<TEmp>, grdResult);
end;

procedure TDeleteEntityFrameG.btCancelDeleteClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := DemoContext.GetEntities<TEmp>.Last;

  // Delete entity from DataContext
  Emp.Delete;
  // Cancel entity deleting
  Emp.Cancel;

  EntitiesToGrid<TEmp>(DemoContext.GetEntities<TEmp>, grdResult);

  inherited;
end;

procedure TDeleteEntityFrameG.btDeleteAndSaveClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := DemoContext.GetEntities<TEmp>.Last;

  // Delete entity from DataContext and Database
  Emp.DeleteAndSave;

  EntitiesToGrid<TEmp>(DemoContext.GetEntities<TEmp>, grdResult);

  inherited;
end;

procedure TDeleteEntityFrameG.btDeleteEntityClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := DemoContext.GetEntities<TEmp>.Last;

  // Delete entity from DataContext
  Emp.Delete;
  // Delete entity from Database
  Emp.Save;

  EntitiesToGrid<TEmp>(DemoContext.GetEntities<TEmp>, grdResult);

  inherited;
end;


end.
