unit DeleteEntityFrameM;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
{$IFNDEF VER12P}
  EntityDAC.Enumerable,
{$ENDIF}  
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.Classes,
  Demo.Linq,
  DemoFrame, DataContextFrame, DeleteEntityFrame;

type
  TDeleteEntityFrameM = class(TDeleteEntityFrame)
    procedure btDeleteEntityClick(Sender: TObject);
    procedure btCancelDeleteClick(Sender: TObject);
    procedure btDeleteAndSaveClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}

procedure TDeleteEntityFrameM.Initialize;
begin
  inherited;

  EntitiesToGrid(DemoContext.GetEntities(TEmp), grdResult);
end;

procedure TDeleteEntityFrameM.btCancelDeleteClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := DemoContext.GetEntities(TEmp).Last as TEmp;

  // Delete entity from DataContext
  Emp.Delete;
  // Cancel entity deleting
  Emp.Cancel;

  EntitiesToGrid(DemoContext.GetEntities(TEmp), grdResult);

  inherited;
end;

procedure TDeleteEntityFrameM.btDeleteAndSaveClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := DemoContext.GetEntities(TEmp).Last as TEmp;

  // Delete entity from DataContext and Database
  Emp.DeleteAndSave;

  EntitiesToGrid(DemoContext.GetEntities(TEmp), grdResult);

  inherited;
end;

procedure TDeleteEntityFrameM.btDeleteEntityClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := DemoContext.GetEntities(TEmp).Last as TEmp;

  // Delete entity from DataContext
  Emp.Delete;
  // Delete entity from Database
  Emp.Save;

  EntitiesToGrid(DemoContext.GetEntities(TEmp), grdResult);

  inherited;
end;


end.
