unit DeleteEntityFrameO;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.Objects,
  DemoFrame, DataContextFrame, DeleteEntityFrame;

type
  TDeleteEntityFrameO = class(TDeleteEntityFrame)
    procedure btDeleteEntityClick(Sender: TObject);
    procedure btCancelDeleteClick(Sender: TObject);
    procedure btDeleteAndSaveClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}

procedure TDeleteEntityFrameO.Initialize;
begin
  inherited;

  EntitiesToGrid<TEmp>(ObjectContext.GetEntities<TEmp>, grdResult);
end;

procedure TDeleteEntityFrameO.btCancelDeleteClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := ObjectContext.GetEntities<TEmp>.Last;

  // Delete entity from DataContext
  ObjectContext.Delete(Emp);
  // Cancel entity deleting
  ObjectContext.Cancel(Emp);

  EntitiesToGrid<TEmp>(ObjectContext.GetEntities<TEmp>, grdResult);

  inherited;
end;

procedure TDeleteEntityFrameO.btDeleteAndSaveClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := ObjectContext.GetEntities<TEmp>.Last;

  // Delete entity from DataContext and Database
  ObjectContext.DeleteAndSave(Emp);

  EntitiesToGrid<TEmp>(ObjectContext.GetEntities<TEmp>, grdResult);

  inherited;
end;

procedure TDeleteEntityFrameO.btDeleteEntityClick(Sender: TObject);
var
  Emp: TEmp;
begin
  Emp := ObjectContext.GetEntities<TEmp>.Last;

  // Delete entity from DataContext
  ObjectContext.Delete(Emp);
  // Delete entity from Database
  ObjectContext.Save(Emp);

  EntitiesToGrid<TEmp>(ObjectContext.GetEntities<TEmp>, grdResult);

  inherited;
end;


end.
