unit EntityDataContextFrame;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, 
  Dialogs, StdCtrls,
  DataContextFrame, ORMDemoPlainEntity, ExtCtrls;

type
  TEntityDataContextFrame = class(TDataContextFrame)
    procedure bt1Click(Sender: TObject);
  private
    FEmp: TEMPEntity;
    FDept: TDEPTEntity;

    function GetContext: TORMDemoAttributesDataContext;
  public
    procedure Initialize; override;
    procedure Finalize; override;

    property DataContext: TORMDemoAttributesDataContext read GetContext;
  end;

implementation

{$R *.dfm}

uses
  Rtti,
  DemoForm,
  Expression, Entity,
  DB;

{ TEntityDataContextFrame }

procedure TEntityDataContextFrame.Initialize;
begin
  inherited;

  if FContext = nil then
    FContext := MainDemoForm.GetAttributeDataContext;
end;

procedure TEntityDataContextFrame.bt1Click(Sender: TObject);
var
  D: IMetaType;
  DataSet: TDataSet;

  i: Integer;
begin
  D := DataContext['DEPT'];
  FDept := DataContext.GetEntity<TDEPTEntity>(DataContext.From(D).Where(D['DEPTNO'] = 1).Select);

  mm.Lines.Add('DEPTNO = ' + IntToStr(FDept.DEPTNO));
  mm.Lines.Add('DNAME = ' + FDept.DNAME);
  mm.Lines.Add('LOC = ' + FDept.LOC);
  mm.Lines.Add('  ');

  for i := 0 to FDept.EMPCollection.Count - 1 do begin
    FEmp := FDept.EMPCollection[i];
    mm.Lines.Add('EMPNO = ' + IntToStr(FEmp.EMPNO));
    mm.Lines.Add('ENAME = ' + FEmp.ENAME);
    mm.Lines.Add('JOB = ' + FEmp.JOB);
    mm.Lines.Add('HIREDATE = ' + DateToStr(FEmp.HIREDATE));
    mm.Lines.Add('SAL = ' + FloatToStr(FEmp.SAL));
    mm.Lines.Add('  ');
  end;
end;

procedure TEntityDataContextFrame.Finalize;
begin
  inherited;
end;

function TEntityDataContextFrame.GetContext: TORMDemoAttributesDataContext;
begin
  Result := TORMDemoAttributesDataContext(FContext);
end;

end.
