unit GetEntitiesFrameE;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls,  DataContextFrame,
  Forms, Dialogs,
  EntityDAC.MetaData,
  EntityDAC.Entity,
  EntityDAC.Enumerable,
  EntityDAC.EntityContext,
  GetEntitiesFrame,
  Demo.AttributeClasses;

type
  TGetEntitiesFrameE = class(TGetEntitiesFrame)
    procedure btGetCollectionByConditionClick(Sender: TObject);
    procedure btGetCollectionByExpressionClick(Sender: TObject);
    procedure btGetCollectionByKeyClick(Sender: TObject);
    procedure btGetCollectionByLinqClick(Sender: TObject);
  end;

implementation

{$R *.dfm}

uses
  EntityDAC.Linq,
  EntityDAC.Linq.Expression,
  EntityDAC.Keys,
  EntityDAC.Values;

procedure TGetEntitiesFrameE.btGetCollectionByConditionClick(Sender: TObject);
var
  Emps: IEntityEnumerable;
begin
  // classic by class type
  Emps := EntityContext.GetEntities(TEmp, 'DeptNo = 20');
  EntitiesToMemo(Emps, mmResult);

  // classic by meta types
  Emps := EntityContext.GetEntities(EntityContext['Emp'], 'DeptNo = 30');
  EntitiesToMemo(Emps, mmResult);

  inherited;
end;

procedure TGetEntitiesFrameE.btGetCollectionByExpressionClick(Sender: TObject);
var
  Emps: IEntityEnumerable;
begin
  // classic by class type
  Emps := EntityContext.GetEntities(TEmp, EntityContext['Emp']['Deptno'] = 10);
  EntitiesToMemo(Emps, mmResult);

  // classic by meta types
  Emps := EntityContext.GetEntities(EntityContext['Emp'], EntityContext['Emp']['Deptno'] = 20);
  EntitiesToMemo(Emps, mmResult);

  inherited;
end;

procedure TGetEntitiesFrameE.btGetCollectionByKeyClick(Sender: TObject);
var
  Key: TEntityKey;
  Emps: IEntityEnumerable;
begin
  Key := TEntityKey.Create(EntityContext['Emp']['Deptno']);
  try
    // classic
    Key.Values[0].AsInteger := 30;
    Emps := EntityContext.GetEntities(Key);
    EntitiesToMemo(Emps, mmResult);
  finally
    Key.Free;
  end;

  inherited;
end;

procedure TGetEntitiesFrameE.btGetCollectionByLinqClick(Sender: TObject);
var
  e: IMetaType;
  Emps: IEntityEnumerable;
  Query: ILinqQueryable;
begin
  e := EntityContext['Emp'];
  Query := Linq.From(e).Where(e['Deptno'] > 20).Select;
  Emps := EntityContext.GetEntities(Query);
  EntitiesToMemo(Emps, mmResult);

  inherited;
end;

end.
