unit GetEntitiesFrameG;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls,  DataContextFrame,
  Forms, Dialogs,
  EntityDAC.MetaData,
  EntityDAC.Entity,
  EntityDAC.Enumerable,
  EntityDAC.EntityContext,
  GetEntitiesFrame,
  Demo.Classes,
  Demo.Linq,
  Demo.MetaData;

type
  TGetEntitiesFrameG = class(TGetEntitiesFrame)
    procedure btGetGCollectionByConditionClick(Sender: TObject);
    procedure btGetGCollectionByExpressionClick(Sender: TObject);
    procedure btGetGCollectionByKeyClick(Sender: TObject);
  end;

implementation

{$R *.dfm}

uses
  EntityDAC.Keys,
  EntityDAC.Linq,
  EntityDAC.Values;

procedure TGetEntitiesFrameG.btGetGCollectionByConditionClick(Sender: TObject);
var
  Emps: IEntityEnumerable<TEmp>;
begin
  // as generic
  Emps := DemoContext.GetEntities<TEmp>('DeptNo = 10');
  EntitiesToMemo<TEmp>(Emps, mmResult);

  inherited;
end;

procedure TGetEntitiesFrameG.btGetGCollectionByExpressionClick(Sender: TObject);
var
  Emps: IEntityEnumerable<TEmp>;
begin
  // as generic
  Emps := DemoContext.GetEntities<TEmp>(DemoContext.Emp.Deptno = 30);
  EntitiesToMemo<TEmp>(Emps, mmResult);

  inherited;
end;

procedure TGetEntitiesFrameG.btGetGCollectionByKeyClick(Sender: TObject);
var
  Key: TEntityKey;
  Emps: IEntityEnumerable<TEmp>;
begin
  Key := TEntityKey.Create(DemoContext.Emp.Deptno);
  try
    // as generic
    Key.Values[0].AsInteger := 20;
    Emps := DemoContext.GetEntities<TEmp>(Key);
    EntitiesToMemo<TEmp>(Emps, mmResult);
  finally
    Key.Free;
  end;

  inherited;
end;
end.
