unit GetEntitiesFrameM;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls,  DataContextFrame,
  Forms, Dialogs,
  EntityDAC.MetaData,
  EntityDAC.Entity,
  EntityDAC.Enumerable,
  EntityDAC.EntityContext,
  GetEntitiesFrame,
  Demo.Classes,
  Demo.Linq,
  Demo.MetaData;

type
  TGetEntitiesFrameM = class(TGetEntitiesFrame)
    procedure btGetCollectionByConditionClick(Sender: TObject);
    procedure btGetCollectionByExpressionClick(Sender: TObject);
    procedure btGetCollectionByLinqClick(Sender: TObject);
    procedure btGetCollectionByKeyClick(Sender: TObject);
  end;

implementation

{$R *.dfm}

uses
  EntityDAC.Keys,
  EntityDAC.Linq,
  EntityDAC.Values;

procedure TGetEntitiesFrameM.btGetCollectionByConditionClick(Sender: TObject);
var
  Emps: IEntityEnumerable;
begin
  // classic by class type
  Emps := DemoContext.GetEntities(TEmp, 'DeptNo = 20');
  EntitiesToMemo(Emps, mmResult);

  // classic by meta types
  Emps := DemoContext.GetEntities(DemoContext.Emp, 'DeptNo = 30');
  EntitiesToMemo(Emps, mmResult);

  inherited;
end;

procedure TGetEntitiesFrameM.btGetCollectionByExpressionClick(Sender: TObject);
var
  Emps: IEntityEnumerable;
begin
  // classic by class type
  Emps := DemoContext.GetEntities(TEmp, DemoContext.Emp.Deptno = 10);
  EntitiesToMemo(Emps, mmResult);

  // classic by meta types
  Emps := DemoContext.GetEntities(DemoContext.Emp, DemoContext.Emp.Deptno = 20);
  EntitiesToMemo(Emps, mmResult);

  inherited;
end;

procedure TGetEntitiesFrameM.btGetCollectionByKeyClick(Sender: TObject);
var
  Key: TEntityKey;
  Emps: IEntityEnumerable;
begin
  Key := TEntityKey.Create(DemoContext.Emp.Deptno);
  try
    // classic
    Key.Values[0].AsInteger := 30;
    Emps := DemoContext.GetEntities(Key);
    EntitiesToMemo(Emps, mmResult);
  finally
    Key.Free;
  end;

  inherited;
end;

procedure TGetEntitiesFrameM.btGetCollectionByLinqClick(Sender: TObject);
var
  e: IEmpExpression;
  Emps: IEntityEnumerable;
  Query: ILinqQueryable;
begin
  e := DemoContext.Emp;
  Query := Linq.From(e).Where(e.Deptno > 20).Select;
  Emps := DemoContext.GetEntities(Query);
  EntitiesToMemo(Emps, mmResult);

  inherited;
end;

end.
