unit GetEntitiesFrameO;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, DataContextFrame,
  Forms, Dialogs,
  EntityDAC.MetaData,
  EntityDAC.Entity,
  EntityDAC.Enumerable,
  EntityDAC.ObjectContext,
  GetEntitiesFrame,
  Demo.Objects;

type
  TGetEntitiesFrameO = class(TGetEntitiesFrame)
    procedure btGetGCollectionByConditionClick(Sender: TObject);
    procedure btGetGCollectionByExpressionClick(Sender: TObject);
    procedure btGetGCollectionByKeyClick(Sender: TObject);
    procedure btGetCollectionByLinqClick(Sender: TObject);
  end;

implementation

{$R *.dfm}

uses
  Rtti,
  EntityDAC.Linq,
  EntityDAC.Linq.Expression,
  EntityDAC.Keys,
  EntityDAC.Values,
  EntityDAC.MetaEntity,
  EntityDAC.RttiUtils;

procedure TGetEntitiesFrameO.btGetGCollectionByConditionClick(Sender: TObject);
var
  Emps:  IObjectEnumerable<TEmp>;
begin
  // as generic
  Emps := ObjectContext.GetEntities<TEmp>('DeptNo = 10');
  EntitiesToMemo<TEmp>(Emps, mmResult);

  inherited;
end;

procedure TGetEntitiesFrameO.btGetGCollectionByExpressionClick(Sender: TObject);
var
  Emps: IObjectEnumerable<TEmp>;
begin
  // as generic
  Emps := ObjectContext.GetEntities<TEmp>(ObjectContext['Emp']['Deptno'] = 30);
  EntitiesToMemo<TEmp>(Emps, mmResult);

  inherited;
end;

procedure TGetEntitiesFrameO.btGetGCollectionByKeyClick(Sender: TObject);
var
  Key: TEntityKey;
  Emps: IObjectEnumerable<TEmp>;
begin
  Key := TEntityKey.Create(ObjectContext['Emp']['Deptno']);
  try
    // as generic
    Key.Values[0].AsInteger := 20;
    Emps := ObjectContext.GetEntities<TEmp>(Key);
    EntitiesToMemo<TEmp>(Emps, mmResult);
  finally
    Key.Free;
  end;

  inherited;
end;

procedure TGetEntitiesFrameO.btGetCollectionByLinqClick(Sender: TObject);
var
  e: IMetaType;
  Emps: IObjectEnumerable;
  Query: ILinqQueryable;
begin
  e := ObjectContext['Emp'];
  Query := Linq.From(e).Where(e['Deptno'] > 20).Select;
  Emps := ObjectContext.GetEntities(Query);
  EntitiesToMemo(Emps, mmResult);

  inherited;
end;

end.
