unit GetEntityCollectionFrameO;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DemoFrame, DataContextFrame, GetEntityCollectionFrame,
  EntityDAC.Entity,
  EntityDAC.Enumerable,
  EntityDAC.EntityContext,
  Demo.Objects;

type
  TGetEntityCollectionFrameO = class(TGetEntityCollectionFrame)
    procedure btGetEntitiesByCollectionClick(Sender: TObject);
    procedure btGetProperiesByCollectionClick(Sender: TObject);
  end;

implementation

{$R *.dfm}

procedure TGetEntityCollectionFrameO.btGetEntitiesByCollectionClick(Sender: TObject);
var
  i: integer;
  Dept: TDept;
  Emp: TEmp;
begin
  // get any Emp
  Dept := ObjectContext.GetEntities<TDept>.First;

  // get Dept by reference
  for i := 0  to Dept.Emps.Count - 1 do begin
    Emp := Dept.Emps[i];
    EntityToMemo(Emp, mmResult);
  end;

  inherited;
end;

procedure TGetEntityCollectionFrameO.btGetProperiesByCollectionClick(Sender: TObject);
var
  i: integer;
  Dept: TDept;
begin
  // get any Emp
  Dept := ObjectContext.GetEntities<TDept>.First;

  // get Dept by reference
  for i := 0  to Dept.Emps.Count - 1 do begin
    mmResult.Lines.Add('---');
    mmResult.Lines.Add('Dept No = ' + VarToStr(Dept.DeptNo));
    mmResult.Lines.Add('Dept Name: ' + VarToStr(Dept.DName));
    mmResult.Lines.Add('Emp No = ' + VarToStr(Dept.Emps[i].EmpNo));
    mmResult.Lines.Add('Emp Name: ' + VarToStr(Dept.Emps[i].EName));
    mmResult.Lines.Add('---');
  end;

  inherited;
end;

end.
