unit GetEntityFrameE;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DemoFrame, DataContextFrame, GetEntityFrame,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.AttributeClasses;

type
  TGetEntityFrameE = class(TGetEntityFrame)
    procedure btGetEntityByIDClick(Sender: TObject);
    procedure btGetEntityByConditionClick(Sender: TObject);
    procedure btGetEntityByExpressionClick(Sender: TObject);
    procedure btGetEntityByPKClick(Sender: TObject);
    procedure btGetEntityByLinqClick(Sender: TObject);
  end;

implementation

{$R *.dfm}

uses
  EntityDAC.Linq,
  EntityDAC.Linq.Expression,
  EntityDAC.Keys, 
  EntityDAC.Values;

procedure TGetEntityFrameE.btGetEntityByIDClick(Sender: TObject);
var
  Dept: TDept;
begin
  // by class type
  Dept := EntityContext.GetEntity(TDept, 20) as TDept;
  EntityToMemo(Dept, mmResult);

  // by meta type
  Dept := EntityContext.GetEntity(EntityContext['Dept'], 30) as TDept;
  EntityToMemo(Dept, mmResult);

  inherited;
end;

procedure TGetEntityFrameE.btGetEntityByConditionClick(Sender: TObject);
var
  Dept: TDept;
begin
  // by class type
  Dept := EntityContext.GetEntity(TDept, 'DeptNo = 20') as TDept;
  EntityToMemo(Dept, mmResult);

  // by meta type
  Dept := EntityContext.GetEntity(EntityContext['Dept'], 'DeptNo = 30') as TDept;
  EntityToMemo(Dept, mmResult);

  inherited;
end;

procedure TGetEntityFrameE.btGetEntityByExpressionClick(Sender: TObject);
var
  Dept: TDept;
begin
  // by class type
  Dept := EntityContext.GetEntity(TDept, EntityContext['Dept']['Deptno'] = 40) as TDept;
  EntityToMemo(Dept, mmResult);

  // by meta type
  Dept := EntityContext.GetEntity(EntityContext['Dept'], EntityContext['Dept']['Deptno'] = 50) as TDept;
  EntityToMemo(Dept, mmResult);

  inherited;
end;

procedure TGetEntityFrameE.btGetEntityByPKClick(Sender: TObject);
var
  PK: TPrimaryKey;
  Dept: TDept;
begin
  PK := TPrimaryKey.Create(EntityContext['Dept']);
  try
    PK.Values[0].AsInteger := 50;
    Dept := EntityContext.GetEntity(PK) as TDept;
    EntityToMemo(Dept, mmResult);
  finally
    PK.Free;
  end;

  inherited;
end;

procedure TGetEntityFrameE.btGetEntityByLinqClick(Sender: TObject);
var
  d: IMetaType;
  Dept: TDept;
  Query: ILinqQueryable;
begin
  d := EntityContext['Dept'];
  Query := Linq.From(d).Where(d['Deptno'] = 10).Select;
  Dept := EntityContext.GetEntity(Query) as TDept;
  EntityToMemo(Dept, mmResult);

  inherited;
end;

end.
