unit GetEntityFrameG;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DemoFrame, DataContextFrame, GetEntityFrame,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.Classes,
  Demo.Linq;

type
  TGetEntityFrameG = class(TGetEntityFrame)
    procedure btGetGEntityByIDClick(Sender: TObject);
    procedure btGetGEntityByConditionClick(Sender: TObject);
    procedure btGetGEntityByExpressionClick(Sender: TObject);
    procedure btGetGEntityByPKClick(Sender: TObject);
    procedure btGetGEntityByLinqClick(Sender: TObject);
  end;

implementation

{$R *.dfm}

uses
  EntityDAC.Keys,
  EntityDAC.Linq,
  EntityDAC.Values;

procedure TGetEntityFrameG.btGetGEntityByIDClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := DemoContext.GetEntity<TDept>(10);
  EntityToMemo(Dept, mmResult);

  inherited;
end;

procedure TGetEntityFrameG.btGetGEntityByConditionClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := DemoContext.GetEntity<TDept>('DeptNo = 10');
  EntityToMemo(Dept, mmResult);

  inherited;
end;

procedure TGetEntityFrameG.btGetGEntityByExpressionClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := DemoContext.GetEntity<TDept>(DemoContext.Dept.Deptno = 30);
  EntityToMemo(Dept, mmResult);

  inherited;
end;

procedure TGetEntityFrameG.btGetGEntityByPKClick(Sender: TObject);
var
  PK: TPrimaryKey;
  Dept: TDept;
begin
  PK := TPrimaryKey.Create(DemoContext.Dept);
  try
    PK.Values[0].AsInteger := 40;
    Dept := DemoContext.GetEntity<TDept>(PK);
    EntityToMemo(Dept, mmResult);
  finally
    PK.Free;
  end;

  inherited;
end;

procedure TGetEntityFrameG.btGetGEntityByLinqClick(Sender: TObject);
var
  Dept: TDept;
  Query: ILinqQueryable;
begin
  Query := Linq.From(DemoContext.Dept).Where(DemoContext.Dept.Deptno = 10).Select;
  Dept := DemoContext.GetEntity<TDept>(Query);
  EntityToMemo(Dept, mmResult);

  inherited;
end;

end.
