unit GetEntityFrameM;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DemoFrame, DataContextFrame, GetEntityFrame,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.Classes,
  Demo.Linq;

type
  TGetEntityFrameM = class(TGetEntityFrame)
    procedure btGetEntityByIDClick(Sender: TObject);
    procedure btGetEntityByConditionClick(Sender: TObject);
    procedure btGetEntityByExpressionClick(Sender: TObject);
    procedure btGetEntityByPKClick(Sender: TObject);
    procedure btGetEntityByLinqClick(Sender: TObject);
  end;

implementation

{$R *.dfm}

uses
  EntityDAC.Keys,
  EntityDAC.Linq,
  EntityDAC.Values;

procedure TGetEntityFrameM.btGetEntityByIDClick(Sender: TObject);
var
  Dept: TDept;
begin
  // by class type
  Dept := DemoContext.GetEntity(TDept, 20) as TDept;
  EntityToMemo(Dept, mmResult);

  // by meta type
  Dept := DemoContext.GetEntity(DemoContext.Dept, 30) as TDept;
  EntityToMemo(Dept, mmResult);

  inherited;
end;

procedure TGetEntityFrameM.btGetEntityByConditionClick(Sender: TObject);
var
  Dept: TDept;
begin
  // by class type
  Dept := DemoContext.GetEntity(TDept, 'DeptNo = 20') as TDept;
  EntityToMemo(Dept, mmResult);

  // by meta type
  Dept := DemoContext.GetEntity(DemoContext.Dept, 'DeptNo = 30') as TDept;
  EntityToMemo(Dept, mmResult);

  inherited;
end;

procedure TGetEntityFrameM.btGetEntityByExpressionClick(Sender: TObject);
var
  Dept: TDept;
begin
  // by class type
  Dept := DemoContext.GetEntity(TDept, DemoContext.Dept.Deptno = 40) as TDept;
  EntityToMemo(Dept, mmResult);

  // by meta type
  Dept := DemoContext.GetEntity(DemoContext.Dept, DemoContext.Dept.Deptno = 50) as TDept;
  EntityToMemo(Dept, mmResult);

  inherited;
end;

procedure TGetEntityFrameM.btGetEntityByPKClick(Sender: TObject);
var
  PK: TPrimaryKey;
  Dept: TDept;
begin
  PK := TPrimaryKey.Create(DemoContext.Dept);
  try
    PK.Values[0].AsInteger := 50;
    Dept := DemoContext.GetEntity(PK) as TDept;
    EntityToMemo(Dept, mmResult);
  finally
    PK.Free;
  end;

  inherited;
end;

procedure TGetEntityFrameM.btGetEntityByLinqClick(Sender: TObject);
var
  d: IDeptExpression;
  Dept: TDept;
  Query: ILinqQueryable;
begin
  d := DemoContext.Dept;
  Query := Linq.From(d).Where(d.Deptno = 10).Select;
  Dept := DemoContext.GetEntity(Query) as TDept;
  EntityToMemo(Dept, mmResult);

  inherited;
end;
end.
