unit GetEntityFrameO;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DemoFrame, DataContextFrame, GetEntityFrame,
  EntityDAC.Entity,
  EntityDAC.ObjectContext,
  Demo.Objects;

type
  TGetEntityFrameO = class(TGetEntityFrame)
    procedure btGetGEntityByIDClick(Sender: TObject);
    procedure btGetGEntityByConditionClick(Sender: TObject);
    procedure btGetGEntityByExpressionClick(Sender: TObject);
    procedure btGetGEntityByPKClick(Sender: TObject);
    procedure btGetGEntityByLinqClick(Sender: TObject);
  end;

implementation

{$R *.dfm}

uses
  EntityDAC.Linq,
  EntityDAC.Linq.Expression,
  EntityDAC.Keys, 
  EntityDAC.Values;

procedure TGetEntityFrameO.btGetGEntityByConditionClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := ObjectContext.GetEntity<TDept>('DeptNo = 10');
  EntityToMemo(Dept, mmResult);

  inherited;
end;

procedure TGetEntityFrameO.btGetGEntityByExpressionClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := ObjectContext.GetEntity<TDept>(ObjectContext['Dept']['Deptno'] = 30);
  EntityToMemo(Dept, mmResult);

  inherited;
end;

procedure TGetEntityFrameO.btGetGEntityByIDClick(Sender: TObject);
var
  Dept: TDept;
begin
  Dept := ObjectContext.GetEntity<TDept>(10);
  EntityToMemo(Dept, mmResult);

  inherited;
end;

procedure TGetEntityFrameO.btGetGEntityByLinqClick(Sender: TObject);
var
  Dept: TDept;
  Query: ILinqQueryable;
begin
  Query := Linq.From(ObjectContext['Dept']).Where(ObjectContext['Dept']['Deptno'] = 10).Select;
  Dept := ObjectContext.GetEntity<TDept>(Query);
  inherited EntityToMemo(Dept, mmResult);

  inherited;
end;

procedure TGetEntityFrameO.btGetGEntityByPKClick(Sender: TObject);
var
  PK: TPrimaryKey;
  Dept: TDept;
begin
  PK := TPrimaryKey.Create(ObjectContext['Dept']);
  try
    PK.Values[0].AsInteger := 40;
    Dept := ObjectContext.GetEntity<TDept>(PK);
    EntityToMemo(Dept, mmResult);
  finally
    PK.Free;
  end;

  inherited;
end;

end.
