unit GetEntityReferenceFrameE;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DemoFrame, DataContextFrame, GetEntityReferenceFrame,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.AttributeClasses;

type
  TGetEntityReferenceFrameE = class(TGetEntityReferenceFrame)
    procedure btGetEntityByReferenceClick(Sender: TObject);
    procedure btGetProperiesByReferenceClick(Sender: TObject);
  end;

implementation

{$R *.dfm}

procedure TGetEntityReferenceFrameE.btGetEntityByReferenceClick(Sender: TObject);
var
  Emp: TEmp;
  Dept: TDept;
begin
  // get any Emp
  Emp := EntityContext.GetEntities(TEmp).First as TEmp;

  // get Dept by reference
  Dept := Emp.Dept;
  EntityToMemo(Dept, mmResult);

  inherited;
end;

procedure TGetEntityReferenceFrameE.btGetProperiesByReferenceClick(Sender: TObject);
var
  Emp: TEmp;
begin
  // get any Emp
  Emp := EntityContext.GetEntities(TEmp).First as TEmp;

  mmResult.Lines.Add('---');
  mmResult.Lines.Add('Emp No = ' + VarToStr(Emp.EmpNo));
  mmResult.Lines.Add('Emp Name: ' + VarToStr(Emp.EName));
  mmResult.Lines.Add('Dept No = ' + VarToStr(Emp.Dept.DeptNo));
  mmResult.Lines.Add('Dept Name: ' + VarToStr(Emp.Dept.DName));
  mmResult.Lines.Add('---');

  inherited;
end;

end.
