unit GetEntityReferenceFrameG;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DemoFrame, DataContextFrame, GetEntityReferenceFrame,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.Classes,
  Demo.Linq;

type
  TGetEntityReferenceFrameG = class(TGetEntityReferenceFrame)
    procedure btGetEntityByReferenceClick(Sender: TObject);
    procedure btGetProperiesByReferenceClick(Sender: TObject);
  end;

implementation

{$R *.dfm}

procedure TGetEntityReferenceFrameG.btGetEntityByReferenceClick(Sender: TObject);
var
  Emp: TEmp;
  Dept: TDept;
begin
  // get any Emp
  Emp := DemoContext.GetEntities<TEmp>.First;

  // get Dept by reference
  Dept := Emp.Dept;
  EntityToMemo(Dept, mmResult);

  inherited;
end;

procedure TGetEntityReferenceFrameG.btGetProperiesByReferenceClick(Sender: TObject);
var
  Emp: TEmp;
begin
  // get any Emp
  Emp := DemoContext.GetEntities<TEmp>.First;

  mmResult.Lines.Add('---');
  mmResult.Lines.Add('Emp No = ' + VarToStr(Emp.EmpNo));
  mmResult.Lines.Add('Emp Name: ' + VarToStr(Emp.EName));
  mmResult.Lines.Add('Dept No = ' + VarToStr(Emp.Dept.DeptNo));
  mmResult.Lines.Add('Dept Name: ' + VarToStr(Emp.Dept.DName));
  mmResult.Lines.Add('---');

  inherited;
end;

end.
