unit ModifyCascadeFrameE;

{$I ..\EntityDAC.Demo.inc}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, StdCtrls, ExtCtrls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls,
  EntityDAC.Entity,
  EntityDAC.EntityContext,
  Demo.AttributeClasses,
  DemoFrame, DataContextFrame, ModifyCascadeFrame;

type
  TModifyCascadeFrameE = class(TModifyCascadeFrame)
    procedure btModifyCascadeClick(Sender: TObject);
    procedure btCanceCascadeClick(Sender: TObject);
  public
    procedure Initialize; override;
  end;

implementation

{$R *.dfm}

procedure TModifyCascadeFrameE.Initialize;
begin
  inherited;

  EntitiesToGrid(EntityContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(EntityContext.GetEntities(TEmp), grdDetail);
end;

procedure TModifyCascadeFrameE.btModifyCascadeClick(Sender: TObject);
var
  i: integer;
  Dept: TDept;
  Emp: TEmp;
begin
  Dept := EntityContext.GetEntities(TDept).First as TDept;

  // Modify Dept
  Dept.DName := 'DName ' + IntToStr(Round(Random(99)));

  // Modify Emps
  for i := 0 to Dept.Emps.Count - 1 do begin
    Emp := Dept.Emps[i];
    Emp.Ename := 'EName ' + IntToStr(Round(Random(99)));
  end;

  // Save cascade
  Dept.Save(True);

  EntitiesToGrid(EntityContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(EntityContext.GetEntities(TEmp), grdDetail);

  inherited;
end;

procedure TModifyCascadeFrameE.btCanceCascadeClick(Sender: TObject);
var
  i: integer;
  Dept: TDept;
  Emp: TEmp;
begin
  Dept := EntityContext.GetEntities(TDept).First as TDept;

  // Modify Dept
  Dept.DName := 'DName ' + IntToStr(Round(Random(99)));

  // Modify Emps
  for i := 0 to Dept.Emps.Count - 1 do begin
    Emp := Dept.Emps[i];
    Emp.Ename := 'EName ' + IntToStr(Round(Random(99)));
  end;

  // Save cascade
  Dept.Cancel(True);

  EntitiesToGrid(EntityContext.GetEntities(TDept), grdMaster);
  EntitiesToGrid(EntityContext.GetEntities(TEmp), grdDetail);

  inherited;
end;

end.
